/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.openejb.cipher.PasswordCipher;
import org.apache.openejb.cipher.PasswordCipherException;
import org.apache.openejb.cipher.PasswordCipherFactory;
import org.apache.openejb.cipher.SafePasswordCipher;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.SuperProperties;

public final class PropertyPlaceHolderHelper {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";
    private static final Properties CACHE = new Properties();
    private static final PropertiesLookup RESOLVER = new PropertiesLookup();
    public static final StrSubstitutor SUBSTITUTOR = new StrSubstitutor((StrLookup)RESOLVER);
    public static final String CIPHER_PREFIX = "cipher:";

    private PropertyPlaceHolderHelper() {
    }

    public static void reset() {
        CACHE.clear();
        RESOLVER.reload();
    }

    public static String simpleValue(String raw) {
        if (raw == null) {
            return null;
        }
        if (!raw.contains(PREFIX) || !raw.contains(SUFFIX)) {
            return (String)String.class.cast(PropertyPlaceHolderHelper.decryptIfNeeded(raw.replace(PREFIX, "").replace(SUFFIX, ""), false));
        }
        String value = SUBSTITUTOR.replace(raw);
        if (!value.equals(raw) && value.startsWith("java:")) {
            value = value.substring(5);
        }
        return (String)String.class.cast(PropertyPlaceHolderHelper.decryptIfNeeded(value.replace(PREFIX, "").replace(SUFFIX, ""), false));
    }

    public static Object simpleValueAsStringOrCharArray(String raw) {
        if (raw == null) {
            return null;
        }
        if (!raw.contains(PREFIX) || !raw.contains(SUFFIX)) {
            return PropertyPlaceHolderHelper.decryptIfNeeded(raw.replace(PREFIX, "").replace(SUFFIX, ""), true);
        }
        String value = SUBSTITUTOR.replace(raw);
        if (!value.equals(raw) && value.startsWith("java:")) {
            value = value.substring(5);
        }
        return PropertyPlaceHolderHelper.decryptIfNeeded(value.replace(PREFIX, "").replace(SUFFIX, ""), true);
    }

    private static Object decryptIfNeeded(String replace, boolean acceptCharArray) {
        if (replace.startsWith(CIPHER_PREFIX)) {
            PasswordCipher cipher;
            String algo = replace.substring(CIPHER_PREFIX.length(), replace.indexOf(58, CIPHER_PREFIX.length() + 1));
            try {
                cipher = PasswordCipherFactory.getPasswordCipher(algo);
            }
            catch (PasswordCipherException ex) {
                try {
                    cipher = (PasswordCipher)PasswordCipher.class.cast(Thread.currentThread().getContextClassLoader().loadClass(algo).newInstance());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            char[] input = replace.substring(CIPHER_PREFIX.length() + algo.length() + 1).toCharArray();
            return acceptCharArray && SafePasswordCipher.class.isInstance(cipher) ? (Object)((SafePasswordCipher)SafePasswordCipher.class.cast(cipher)).decryptAsCharArray(input) : cipher.decrypt(input);
        }
        return replace;
    }

    public static String value(String aw) {
        if (aw == null) {
            return null;
        }
        if (!aw.contains(PREFIX) || !aw.contains(SUFFIX)) {
            return (String)String.class.cast(PropertyPlaceHolderHelper.decryptIfNeeded(aw, false));
        }
        String value = CACHE.getProperty(aw);
        if (value != null) {
            return value;
        }
        value = PropertyPlaceHolderHelper.simpleValue(aw);
        CACHE.setProperty(aw, value);
        return value;
    }

    public static Properties simpleHolds(Properties properties) {
        return PropertyPlaceHolderHelper.holds(properties, false);
    }

    public static Properties holds(Properties properties) {
        return PropertyPlaceHolderHelper.holds(properties, true);
    }

    private static Properties holds(Properties properties, boolean cache) {
        SuperProperties updated = new SuperProperties();
        if (properties == null) {
            return updated;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object rawValue = entry.getValue();
            if (rawValue instanceof String) {
                String value = (String)rawValue;
                ((Properties)updated).put(entry.getKey(), cache ? PropertyPlaceHolderHelper.value(value) : PropertyPlaceHolderHelper.simpleValueAsStringOrCharArray(value));
                continue;
            }
            ((Properties)updated).put(entry.getKey(), rawValue);
        }
        return updated;
    }

    public static void holdsWithUpdate(Properties props) {
        Properties toUpdate = PropertyPlaceHolderHelper.holds(props);
        props.putAll((Map<?, ?>)toUpdate);
    }

    static {
        SUBSTITUTOR.setEnableSubstitutionInVariables(true);
        SUBSTITUTOR.setValueDelimiter(System.getProperty("openejb.placehodler.delimiter", ":-"));
    }

    private static class PropertiesLookup
    extends StrLookup<Object> {
        private static final Map<String, String> ENV = System.getenv();

        private PropertiesLookup() {
        }

        public synchronized String lookup(String key) {
            String value = SystemInstance.get().getProperties().getProperty(key);
            if (value != null) {
                return value;
            }
            value = ENV.get(key);
            if (value != null) {
                return value;
            }
            return null;
        }

        public synchronized void reload() {
        }
    }
}

