/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Collection;

public final class NetworkUtil {
    private NetworkUtil() {
    }

    public static int getNextAvailablePort() {
        return NetworkUtil.getNextAvailablePort(new int[]{0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextAvailablePort(int[] portList) {
        int port;
        ServerSocket s = null;
        try {
            s = NetworkUtil.create(portList);
            port = s.getLocalPort();
        }
        catch (IOException ioe) {
            port = -1;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextAvailablePort(int min, int max, Collection<Integer> excepted) {
        int port = -1;
        ServerSocket s = null;
        for (int i = min; i <= max; ++i) {
            try {
                s = NetworkUtil.create(new int[]{i});
                port = s.getLocalPort();
                if (excepted != null && excepted.contains(port)) continue;
                break;
            }
            catch (IOException ioe) {
                port = -1;
                continue;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return port;
    }

    private static ServerSocket create(int[] ports) throws IOException {
        for (int port : ports) {
            try {
                return new ServerSocket(port);
            }
            catch (IOException iOException) {
            }
        }
        throw new IOException("No free port found");
    }

    public static String getLocalAddress(String start, String end) {
        return start + "localhost:" + NetworkUtil.getNextAvailablePort() + end;
    }

    public static boolean isLocalAddress(String addr) {
        try {
            return NetworkUtil.isLocalAddress(InetAddress.getByName(addr));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLocalAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static final class LastPort {
        private final int port;

        private LastPort(int port) {
            this.port = port;
        }
    }
}

