/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.managed.local;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.openejb.resource.jdbc.managed.local.LocalXAResource;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ManagedConnection
implements InvocationHandler {
    private final TransactionManager transactionManager;
    private final Key key;
    private final TransactionSynchronizationRegistry registry;
    protected XAResource xaResource;
    protected Connection delegate;
    protected XAConnection xaConnection;
    private Transaction currentTransaction;
    private boolean closed;

    public ManagedConnection(CommonDataSource ds, TransactionManager txMgr, TransactionSynchronizationRegistry txRegistry, String user, String password) {
        this.transactionManager = txMgr;
        this.registry = txRegistry;
        this.closed = false;
        this.key = new Key(ds, user, password);
    }

    public XAResource getXAResource() throws SQLException {
        if (this.xaResource == null) {
            this.newConnection();
        }
        return this.xaResource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mtdName = method.getName();
        if ("toString".equals(mtdName)) {
            return "ManagedConnection{" + this.delegate + "}";
        }
        if ("hashCode".equals(mtdName)) {
            return this.hashCode();
        }
        if ("equals".equals(mtdName)) {
            return args[0] == this || this.delegate != null && this.delegate.equals(args[0]);
        }
        if (Wrapper.class == method.getDeclaringClass() && args.length == 1 && Connection.class == args[0]) {
            if ("isWrapperFor".equals(mtdName)) {
                return true;
            }
            if ("unwrap".equals(mtdName)) {
                return this.delegate;
            }
        }
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                if ("close".equals(mtdName)) {
                    if (this.delegate == null) {
                        return null;
                    }
                    ManagedConnection.closeConnection(this.xaConnection, this.delegate);
                    return null;
                }
                if (this.delegate == null) {
                    this.newConnection();
                }
                return ManagedConnection.invoke(method, this.delegate, args);
            }
            if (this.currentTransaction != null && ManagedConnection.isUnderTransaction(this.currentTransaction.getStatus())) {
                if (!this.currentTransaction.equals(transaction)) {
                    throw new SQLException("Connection can not be used while enlisted in another transaction");
                }
                return this.invokeUnderTransaction(this.delegate, method, args);
            }
            if (ManagedConnection.isUnderTransaction(transaction.getStatus())) {
                Connection connection;
                block25: {
                    connection = (Connection)Connection.class.cast(this.registry.getResource((Object)this.key));
                    if (connection == null && this.delegate == null) {
                        this.newConnection();
                        connection = this.delegate;
                        this.registry.putResource((Object)this.key, (Object)this.delegate);
                        this.currentTransaction = transaction;
                        try {
                            transaction.enlistResource(this.getXAResource());
                        }
                        catch (RollbackException rollbackException) {
                        }
                        catch (SystemException e) {
                            throw new SQLException("Unable to enlist connection the transaction", e);
                        }
                        transaction.registerSynchronization((Synchronization)new ClosingSynchronization(this.xaConnection, this.delegate));
                        try {
                            this.setAutoCommit(false);
                        }
                        catch (SQLException xae) {
                            String message = "Can't set auto commit to false cause the XA datasource doesn't support it, this is likely an issue";
                            Logger logger = Logger.getInstance(LogCategory.OPENEJB_RESOURCE_JDBC, ManagedConnection.class);
                            if (logger.isDebugEnabled()) {
                                logger.warning("Can't set auto commit to false cause the XA datasource doesn't support it, this is likely an issue", xae);
                                break block25;
                            }
                            logger.warning("Can't set auto commit to false cause the XA datasource doesn't support it, this is likely an issue");
                        }
                    } else if (this.delegate == null) {
                        this.delegate = connection;
                    }
                }
                return this.invokeUnderTransaction(connection, method, args);
            }
            if (this.delegate == null) {
                this.newConnection();
            }
            return ManagedConnection.invoke(method, this.delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Object newConnection() throws SQLException {
        Object connection;
        Object object = DataSource.class.isInstance(this.key.ds) ? (this.key.user == null ? ((DataSource)DataSource.class.cast(this.key.ds)).getConnection() : ((DataSource)DataSource.class.cast(this.key.ds)).getConnection(this.key.user, this.key.pwd)) : (connection = this.key.user == null ? ((XADataSource)XADataSource.class.cast(this.key.ds)).getXAConnection() : ((XADataSource)XADataSource.class.cast(this.key.ds)).getXAConnection(this.key.user, this.key.pwd));
        if (XAConnection.class.isInstance(connection)) {
            this.xaConnection = (XAConnection)XAConnection.class.cast(connection);
            this.delegate = this.xaConnection.getConnection();
            this.xaResource = this.xaConnection.getXAResource();
        } else {
            this.delegate = (Connection)Connection.class.cast(connection);
            this.xaResource = new LocalXAResource(this.delegate);
        }
        return connection;
    }

    protected void setAutoCommit(boolean value) throws SQLException {
        if (this.delegate == null) {
            this.newConnection();
        }
        this.delegate.setAutoCommit(value);
    }

    private static Object invoke(Method method, Connection delegate, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)delegate, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    private Object invokeUnderTransaction(Connection delegate, Method method, Object[] args) throws Exception {
        String mtdName = method.getName();
        if ("setAutoCommit".equals(mtdName) || "commit".equals(mtdName) || "rollback".equals(mtdName) || "setSavepoint".equals(mtdName) || "setReadOnly".equals(mtdName)) {
            throw ManagedConnection.forbiddenCall(mtdName);
        }
        if ("close".equals(mtdName)) {
            return this.close();
        }
        if ("isClosed".equals(mtdName) && this.closed) {
            return true;
        }
        return method.invoke((Object)delegate, args);
    }

    private Object close() {
        this.closed = true;
        return null;
    }

    private static boolean isUnderTransaction(int status) {
        return status == 0 || status == 1;
    }

    private static SQLException forbiddenCall(String mtdName) {
        return new SQLException("can't call " + mtdName + " when the connection is JtaManaged");
    }

    private static void closeConnection(XAConnection xaConnection, Connection connection) {
        try {
            if (xaConnection != null) {
                xaConnection.close();
            } else if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static final class Key {
        private final CommonDataSource ds;
        private final String user;
        private final String pwd;
        private final int hash;

        private Key(CommonDataSource ds, String user, String pwd) {
            this.ds = ds;
            this.user = user;
            this.pwd = pwd;
            int result = ds.hashCode();
            result = 31 * result + (user != null ? user.hashCode() : 0);
            this.hash = result = 31 * result + (pwd != null ? pwd.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)Key.class.cast(o);
            return !(this.ds != key.ds && !this.ds.equals(key.ds) || (this.user == null ? key.user != null : !this.user.equals(key.user)) || (this.pwd == null ? key.pwd != null : !this.pwd.equals(key.pwd)));
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class ClosingSynchronization
    implements Synchronization {
        private final XAConnection xaConnection;
        private final Connection connection;

        public ClosingSynchronization(XAConnection xaConnection, Connection delegate) {
            this.xaConnection = xaConnection;
            this.connection = delegate;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ManagedConnection.closeConnection(this.xaConnection, this.connection);
        }
    }
}

