/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.CommonDataSource;
import org.apache.openejb.resource.jdbc.DelegatableHandler;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ResettableDataSourceHandler
implements DelegatableHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, ResettableDataSourceHandler.class.getName());
    private final AtomicReference<CommonDataSource> delegate = new AtomicReference();
    private final RetryStrategy strategy;
    private Set<String> retryMethods = new HashSet<String>();

    public ResettableDataSourceHandler(CommonDataSource ds, String value, String methods) {
        RetryStrategy tmp;
        this.delegate.set(ds);
        if (!"*".equals(methods)) {
            String[] stringArray;
            if (methods == null) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "getConnection";
                stringArray = stringArray2;
                stringArray2[1] = "getXAConnection";
            } else {
                stringArray = methods.split(" *, *");
            }
            this.retryMethods.addAll(Arrays.asList(stringArray));
        }
        Runnable recreate = new Runnable(){

            @Override
            public void run() {
                try {
                    ((Flushable)Flushable.class.cast(ResettableDataSourceHandler.this.delegate.get())).flush();
                }
                catch (IOException ioe) {
                    LOGGER.error("Can't flush connection pool: " + ioe.getMessage());
                }
            }
        };
        if (value.equals("true")) {
            tmp = new CountRetryStrategy(recreate, 1);
        } else if (value.startsWith("retry(") && value.endsWith(")")) {
            tmp = new CountRetryStrategy(recreate, Integer.parseInt(value.substring("retry(".length(), value.length() - 1)));
        } else {
            try {
                tmp = new CountRetryStrategy(recreate, Integer.parseInt(value.trim()));
            }
            catch (NumberFormatException nfe) {
                try {
                    tmp = (RetryStrategy)RetryStrategy.class.cast(Thread.currentThread().getContextClassLoader().loadClass(value).getConstructor(Runnable.class, String.class).newInstance(recreate, value));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Unknown retry strategy: " + value, e);
                }
            }
        }
        this.strategy = tmp;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class == method.getDeclaringClass() && "toString".equals(method.getName())) {
            return "Resettable[" + this.getDelegate().toString() + "]";
        }
        Result retry = null;
        while (true) {
            try {
                return method.invoke((Object)this.getDelegate(), args);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (SQLException.class.isInstance(cause) && this.isRetryMethod(method)) {
                    if ((retry = this.strategy.shouldRetry(cause, retry)).status) continue;
                    throw cause;
                }
                throw cause;
            }
            break;
        }
    }

    private boolean isRetryMethod(Method method) {
        return this.retryMethods.isEmpty() || this.retryMethods.contains(method.getName());
    }

    @Override
    public CommonDataSource getDelegate() {
        return this.delegate.get();
    }

    public void updateDelegate(CommonDataSource ds) {
        this.delegate.set(ds);
    }

    private static class CountResult
    extends Result {
        private int count;

        public CountResult(boolean status, int count) {
            super(status);
            this.count = count;
        }
    }

    private static class CountRetryStrategy
    implements RetryStrategy {
        private final Runnable task;
        private final int max;

        public CountRetryStrategy(Runnable recreate, int max) {
            this.task = recreate;
            this.max = max;
        }

        @Override
        public Result shouldRetry(Throwable cause, Result previous) {
            LOGGER.error("SQLException, resetting the connection pool.", cause);
            Integer count = previous == null ? 1 : ((CountResult)CountResult.class.cast(previous)).count + 1;
            this.task.run();
            return new CountResult(count <= this.max, count);
        }
    }

    public static class Result {
        private final boolean status;

        public Result(boolean status) {
            this.status = status;
        }
    }

    public static interface RetryStrategy {
        public Result shouldRetry(Throwable var1, Result var2);
    }
}

