/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.SynchronizationType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.ReloadableEntityManagerFactory;
import org.apache.openejb.core.ivm.IntraVmArtifact;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.persistence.JtaQuery;
import org.apache.openejb.persistence.JtaTypedQuery;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.reflection.Reflections;

public class JtaEntityManager
implements EntityManager,
Serializable {
    private static final Logger baseLogger = Logger.getInstance(LogCategory.OPENEJB.createChild("persistence"), JtaEntityManager.class);
    private static final Method CREATE_NAMED_QUERY_FROM_NAME = Reflections.findMethod("createNamedQuery", EntityManager.class, String.class);
    private static final Method CREATE_QUERY_FROM_NAME = Reflections.findMethod("createQuery", EntityManager.class, String.class);
    private static final Method CREATE_NATIVE_FROM_NAME = Reflections.findMethod("createNativeQuery", EntityManager.class, String.class);
    private static final Method CREATE_NAMED_QUERY_FROM_NAME_CLASS = Reflections.findMethod("createNamedQuery", EntityManager.class, String.class, Class.class);
    private static final Method CREATE_QUERY_FROM_NAME_CLASS = Reflections.findMethod("createQuery", EntityManager.class, String.class, Class.class);
    private static final Method CREATE_QUERY_FROM_CRITERIA = Reflections.findMethod("createQuery", EntityManager.class, CriteriaQuery.class);
    private static final Method CREATE_NATIVE_FROM_NAME_CLASS = Reflections.findMethod("createNativeQuery", EntityManager.class, String.class, Class.class);
    private static final Method CREATE_NATIVE_FROM_NAME_MAPPING = Reflections.findMethod("createNativeQuery", EntityManager.class, String.class, String.class);
    private static final ConcurrentMap<Class<?>, Boolean> IS_JPA21 = new ConcurrentHashMap();
    private final JtaEntityManagerRegistry registry;
    private final EntityManagerFactory entityManagerFactory;
    private final Map properties;
    private final boolean extended;
    private final SynchronizationType synchronizationType;
    private final String unitName;
    private final Logger logger;
    private final boolean wrapNoTxQueries;
    private final boolean timer;

    public JtaEntityManager(JtaEntityManagerRegistry registry, EntityManagerFactory entityManagerFactory, Map properties, String unitName, String synchronizationType) {
        this(unitName, registry, entityManagerFactory, properties, false, synchronizationType);
    }

    public JtaEntityManager(String unitName, JtaEntityManagerRegistry registry, EntityManagerFactory entityManagerFactory, Map properties, boolean extended, String synchronizationType) {
        Object localTimerConfig;
        if (registry == null) {
            throw new NullPointerException("registry is null");
        }
        if (entityManagerFactory == null) {
            throw new NullPointerException("entityManagerFactory is null");
        }
        this.unitName = unitName;
        this.registry = registry;
        this.entityManagerFactory = entityManagerFactory;
        this.properties = properties;
        this.extended = extended;
        this.synchronizationType = !JtaEntityManager.isJPA21(entityManagerFactory) || synchronizationType == null ? null : SynchronizationType.valueOf((String)synchronizationType.toUpperCase(Locale.ENGLISH));
        String globalTimerConfig = SystemInstance.get().getProperty("openejb.jpa.timer");
        Object object = localTimerConfig = properties == null ? null : (Object)properties.get("openejb.jpa.timer");
        this.timer = localTimerConfig == null ? globalTimerConfig == null || Boolean.parseBoolean(globalTimerConfig) : Boolean.parseBoolean(localTimerConfig.toString());
        this.logger = unitName == null ? baseLogger : baseLogger.getChildLogger(unitName);
        String wrapConfig = ReloadableEntityManagerFactory.class.isInstance(entityManagerFactory) ? ((ReloadableEntityManagerFactory)ReloadableEntityManagerFactory.class.cast(entityManagerFactory)).getUnitProperties().getProperty("openejb.jpa.query.wrap-no-tx", "true") : "true";
        this.wrapNoTxQueries = wrapConfig == null || "true".equalsIgnoreCase(wrapConfig);
    }

    public static boolean isJPA21(EntityManagerFactory entityManagerFactory) {
        return ReloadableEntityManagerFactory.class.isInstance(entityManagerFactory) ? JtaEntityManager.isJPA21(((ReloadableEntityManagerFactory)ReloadableEntityManagerFactory.class.cast(entityManagerFactory)).getDelegate()) : JtaEntityManager.hasMethod(entityManagerFactory, "createEntityManager", SynchronizationType.class);
    }

    private static boolean hasMethod(Object object, String name, Class<?> ... params) {
        try {
            Class<?> objectClass = object.getClass();
            Boolean result = (Boolean)IS_JPA21.get(objectClass);
            if (result == null) {
                result = !Modifier.isAbstract(objectClass.getMethod(name, params).getModifiers());
                if (objectClass.getClassLoader() == JtaEntityManager.class.getClassLoader()) {
                    IS_JPA21.putIfAbsent(objectClass, result);
                }
            }
            return result;
        }
        catch (Throwable e) {
            return false;
        }
    }

    EntityManager getEntityManager() {
        return this.registry.getEntityManager(this.entityManagerFactory, this.properties, this.extended, this.unitName, this.synchronizationType);
    }

    boolean isTransactionActive() {
        return this.registry.isTransactionActive();
    }

    private void assertTransactionActive() throws TransactionRequiredException {
        if (!this.extended && !this.isTransactionActive()) {
            throw new TransactionRequiredException();
        }
    }

    void closeIfNoTx(EntityManager entityManager) {
        if (!this.extended && !this.isTransactionActive()) {
            entityManager.close();
            this.logger.debug("Closed EntityManager(unit=" + this.unitName + ", hashCode=" + entityManager.hashCode() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager getDelegate() {
        Timer timer = Op.getDelegate.start(this.timer, this);
        try {
            EntityManager em = this.getEntityManager();
            em.getDelegate();
            EntityManager entityManager = em;
            return entityManager;
        }
        finally {
            timer.stop();
        }
    }

    public void persist(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.persist.start(this.timer, this);
        try {
            this.getEntityManager().persist(entity);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        this.assertTransactionActive();
        Timer timer = Op.merge.start(this.timer, this);
        try {
            Object object = this.getEntityManager().merge(entity);
            return (T)object;
        }
        finally {
            timer.stop();
        }
    }

    public void remove(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.remove.start(this.timer, this);
        try {
            this.getEntityManager().remove(entity);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this.timer, this);
            try {
                object = entityManager.find(entityClass, primaryKey);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.getReference.start(this.timer, this);
            try {
                object = entityManager.getReference(entityClass, primaryKey);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    public void flush() {
        this.assertTransactionActive();
        Timer timer = Op.flush.start(this.timer, this);
        try {
            this.getEntityManager().flush();
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.setFlushMode.start(this.timer, this);
            try {
                entityManager.setFlushMode(flushMode);
            }
            finally {
                timer.stop();
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.getFlushMode.start(this.timer, this);
            try {
                FlushModeType flushModeType = entityManager.getFlushMode();
                timer.stop();
                return flushModeType;
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        this.assertTransactionActive();
        Timer timer = Op.lock.start(this.timer, this);
        try {
            this.getEntityManager().lock(entity, lockMode);
        }
        finally {
            timer.stop();
        }
    }

    public void refresh(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this.timer, this);
        try {
            this.getEntityManager().refresh(entity);
        }
        finally {
            timer.stop();
        }
    }

    public void clear() {
        if (!this.extended && !this.isTransactionActive()) {
            return;
        }
        Timer timer = Op.clear.start(this.timer, this);
        try {
            this.getEntityManager().clear();
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        Timer timer = Op.contains.start(this.timer, this);
        try {
            boolean bl = (this.extended || this.isTransactionActive()) && this.getEntityManager().contains(entity);
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String qlString) {
        Timer timer = Op.createQuery.start(this.timer, this);
        try {
            Query query = this.proxyIfNoTx(CREATE_QUERY_FROM_NAME, qlString);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String name) {
        Timer timer = Op.createNamedQuery.start(this.timer, this);
        try {
            Query query = this.proxyIfNoTx(CREATE_NAMED_QUERY_FROM_NAME, name);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString) {
        Timer timer = Op.createNativeQuery.start(this.timer, this);
        try {
            Query query = this.proxyIfNoTx(CREATE_NATIVE_FROM_NAME, sqlString);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, Class resultClass) {
        Timer timer = Op.createNativeQuery.start(this.timer, this);
        try {
            Query query = this.proxyIfNoTx(CREATE_NATIVE_FROM_NAME_CLASS, sqlString, resultClass);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Timer timer = Op.createNativeQuery.start(this.timer, this);
        try {
            Query query = this.proxyIfNoTx(CREATE_NATIVE_FROM_NAME_MAPPING, sqlString, resultSetMapping);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    private Query proxyIfNoTx(Method method, Object ... args) {
        if (this.wrapNoTxQueries && !this.extended && !this.isTransactionActive()) {
            return new JtaQuery(this.getEntityManager(), this, method, args);
        }
        return this.createQuery(Query.class, this.getEntityManager(), method, args);
    }

    private <T> TypedQuery<T> typedProxyIfNoTx(Method method, Object ... args) {
        if (this.wrapNoTxQueries && !this.extended && !this.isTransactionActive()) {
            return new JtaTypedQuery(this.getEntityManager(), this, method, args);
        }
        return this.createQuery(TypedQuery.class, this.getEntityManager(), method, args);
    }

    <T> T createQuery(Class<T> expected, EntityManager entityManager, Method method, Object ... args) {
        try {
            return expected.cast(method.invoke((Object)entityManager, args));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (RuntimeException.class.isInstance(t)) {
                throw (RuntimeException)RuntimeException.class.cast(t);
            }
            throw new OpenEJBRuntimeException(t.getMessage(), t);
        }
    }

    public void joinTransaction() {
        Timer timer = Op.joinTransaction.start(this.timer, this);
        try {
            this.getDelegate().joinTransaction();
        }
        finally {
            timer.stop();
        }
    }

    public void close() {
        throw new IllegalStateException("PersistenceUnit(name=" + this.unitName + ") - entityManager.close() call - See JPA 2.0 section 7.9.1", new Exception().fillInStackTrace());
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("A JTA EntityManager can not use the EntityTransaction API.  See JPA 1.0 section 5.5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        Timer timer = Op.createNamedQuery.start(this.timer, this);
        try {
            TypedQuery<T> typedQuery = this.typedProxyIfNoTx(CREATE_NAMED_QUERY_FROM_NAME_CLASS, name, resultClass);
            return typedQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        Timer timer = Op.createQuery.start(this.timer, this);
        try {
            TypedQuery<T> typedQuery = this.typedProxyIfNoTx(CREATE_QUERY_FROM_CRITERIA, criteriaQuery);
            return typedQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        Timer timer = Op.createQuery.start(this.timer, this);
        try {
            TypedQuery<T> typedQuery = this.typedProxyIfNoTx(CREATE_QUERY_FROM_NAME_CLASS, qlString, resultClass);
            return typedQuery;
        }
        finally {
            timer.stop();
        }
    }

    public void detach(Object entity) {
        Timer timer = Op.detach.start(this.timer, this);
        try {
            if (!this.extended && this.isTransactionActive()) {
                this.getEntityManager().detach(entity);
            }
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this.timer, this);
            try {
                object = entityManager.find(entityClass, primaryKey, properties);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this.timer, this);
            try {
                object = entityManager.find(entityClass, primaryKey, lockMode);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this.timer, this);
            try {
                object = entityManager.find(entityClass, primaryKey, lockMode, properties);
                timer.stop();
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
            return (T)object;
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModeType getLockMode(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.getLockMode.start(this.timer, this);
        try {
            LockModeType lockModeType = this.getEntityManager().getLockMode(entity);
            return lockModeType;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metamodel getMetamodel() {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.getMetamodel.start(this.timer, this);
            try {
                Metamodel metamodel = entityManager.getMetamodel();
                timer.stop();
                return metamodel;
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.getProperties.start(this.timer, this);
            try {
                Map map = entityManager.getProperties();
                timer.stop();
                return map;
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaBuilder getCriteriaBuilder() {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.getCriteriaBuilder.start(this.timer, this);
            try {
                CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
                timer.stop();
                return criteriaBuilder;
            }
            catch (Throwable throwable) {
                timer.stop();
                throw throwable;
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.assertTransactionActive();
        Timer timer = Op.lock.start(this.timer, this);
        try {
            this.getEntityManager().lock(entity, lockMode, properties);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, Map<String, Object> properties) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this.timer, this);
        try {
            this.getEntityManager().refresh(entity, properties);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this.timer, this);
        try {
            this.getEntityManager().refresh(entity, lockMode);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this.timer, this);
        try {
            this.getEntityManager().refresh(entity, lockMode, properties);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, Object value) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.setProperty.start(this.timer, this);
            try {
                entityManager.setProperty(name, value);
            }
            finally {
                timer.stop();
            }
        }
        finally {
            this.closeIfNoTx(entityManager);
        }
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getEntityManager().unwrap(cls);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new IntraVmArtifact(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        Timer timer = Op.createNamedStoredProcedureQuery.start(this.timer, this);
        try {
            StoredProcedureQuery storedProcedureQuery = this.getEntityManager().createNamedStoredProcedureQuery(name);
            return storedProcedureQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        Timer timer = Op.createNamedStoredProcedureQuery.start(this.timer, this);
        try {
            StoredProcedureQuery storedProcedureQuery = this.getEntityManager().createStoredProcedureQuery(procedureName);
            return storedProcedureQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        Timer timer = Op.createStoredProcedureQuery.start(this.timer, this);
        try {
            StoredProcedureQuery storedProcedureQuery = this.getEntityManager().createStoredProcedureQuery(procedureName, resultClasses);
            return storedProcedureQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        Timer timer = Op.createStoredProcedureQuery.start(this.timer, this);
        try {
            StoredProcedureQuery storedProcedureQuery = this.getEntityManager().createStoredProcedureQuery(procedureName, resultSetMappings);
            return storedProcedureQuery;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(CriteriaUpdate updateQuery) {
        Timer timer = Op.createQuery.start(this.timer, this);
        try {
            Query query = this.getEntityManager().createQuery(updateQuery);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(CriteriaDelete deleteQuery) {
        Timer timer = Op.createQuery.start(this.timer, this);
        try {
            Query query = this.getEntityManager().createQuery(deleteQuery);
            return query;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        Timer timer = Op.createEntityGraph.start(this.timer, this);
        try {
            EntityGraph entityGraph = this.getEntityManager().createEntityGraph(rootType);
            return entityGraph;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityGraph<?> createEntityGraph(String graphName) {
        Timer timer = Op.createEntityGraph.start(this.timer, this);
        try {
            EntityGraph entityGraph = this.getEntityManager().createEntityGraph(graphName);
            return entityGraph;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityGraph<?> getEntityGraph(String graphName) {
        Timer timer = Op.getEntityGraph.start(this.timer, this);
        try {
            EntityGraph entityGraph = this.getEntityManager().getEntityGraph(graphName);
            return entityGraph;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        Timer timer = Op.getEntityGraphs.start(this.timer, this);
        try {
            List list = this.getEntityManager().getEntityGraphs(entityClass);
            return list;
        }
        finally {
            timer.stop();
        }
    }

    public boolean isJoinedToTransaction() {
        Timer timer = Op.isJoinedToTransaction.start(this.timer, this);
        try {
            boolean bl = this.synchronizationType == null || this.getEntityManager().isJoinedToTransaction();
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    private static enum Op {
        clear,
        close,
        contains,
        createNamedQuery,
        createNativeQuery,
        createQuery,
        find,
        flush,
        getFlushMode,
        getReference,
        getTransaction,
        lock,
        merge,
        refresh,
        remove,
        setFlushMode,
        persist,
        detach,
        getLockMode,
        unwrap,
        setProperty,
        getCriteriaBuilder,
        getProperties,
        getMetamodel,
        joinTransaction,
        getDelegate,
        createNamedStoredProcedureQuery,
        createStoredProcedureQuery,
        createEntityGraph,
        getEntityGraph,
        getEntityGraphs,
        isJoinedToTransaction;

        private static final Timer NOOP;

        public Timer start(boolean timer, JtaEntityManager em) {
            return timer ? new Timer(this, em) : NOOP;
        }

        static {
            NOOP = new Timer(null, null){

                @Override
                public void stop() {
                }
            };
        }
    }

    public static class Timer {
        private final long start = System.nanoTime();
        private final Op operation;
        private final JtaEntityManager em;

        public Timer(Op operation, JtaEntityManager em) {
            this.operation = operation;
            this.em = em;
        }

        public void stop() {
            if (!this.em.logger.isDebugEnabled()) {
                return;
            }
            long time = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            this.em.logger.debug("PersistenceUnit(name=" + this.em.unitName + ") - entityManager." + (Object)((Object)this.operation) + " - " + time + "ms");
        }
    }
}

