/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.dyni;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;
import org.apache.openejb.util.proxy.ProxyGenerationException;
import org.apache.xbean.asm5.AnnotationVisitor;
import org.apache.xbean.asm5.ClassReader;
import org.apache.xbean.asm5.ClassVisitor;
import org.apache.xbean.asm5.ClassWriter;
import org.apache.xbean.asm5.MethodVisitor;
import org.apache.xbean.asm5.Opcodes;
import org.apache.xbean.asm5.Type;

public class DynamicSubclass
implements Opcodes {
    private static final ReentrantLock LOCK = new ReentrantLock();
    public static final String IMPL_SUFFIX = "$$Impl";

    public static boolean isDynamic(Class beanClass) {
        return Modifier.isAbstract(beanClass.getModifiers()) && InvocationHandler.class.isAssignableFrom(beanClass);
    }

    public static Class createSubclass(Class<?> abstractClass, ClassLoader cl) {
        String proxyName = DynamicSubclass.getSubclassName(abstractClass);
        try {
            return cl.loadClass(proxyName);
        }
        catch (Exception exception) {
            ReentrantLock lock = LOCK;
            lock.lock();
            try {
                Class<?> clazz = cl.loadClass(proxyName);
                return clazz;
            }
            catch (Exception exception2) {
                Class clazz = LocalBeanProxyFactory.Unsafe.defineClass(cl, abstractClass, proxyName, DynamicSubclass.generateBytes(abstractClass));
                return clazz;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static byte[] generateBytes(Class<?> classToProxy) throws ProxyGenerationException {
        HashMap<String, MethodVisitor> visitors = new HashMap<String, MethodVisitor>();
        ClassWriter cw = new ClassWriter(2);
        String proxyClassFileName = DynamicSubclass.getSubclassName(classToProxy).replace('.', '/');
        String classFileName = classToProxy.getName().replace('.', '/');
        cw.visit(49, 33, proxyClassFileName, null, classFileName, null);
        cw.visitSource(classFileName + ".java", null);
        cw.visitField(18, "this$handler", "Ljava/lang/reflect/InvocationHandler;", null, null).visitEnd();
        for (Constructor<?> constructor : classToProxy.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            MethodVisitor mv = DynamicSubclass.visitConstructor(cw, proxyClassFileName, classFileName, constructor);
            visitors.put("<init>" + Type.getConstructorDescriptor(constructor), mv);
        }
        HashMap<String, List<Method>> methodMap = new HashMap<String, List<Method>>();
        DynamicSubclass.getNonPrivateMethods(classToProxy, methodMap);
        for (Map.Entry entry : methodMap.entrySet()) {
            for (Method method : (List)entry.getValue()) {
                if (!Modifier.isAbstract(method.getModifiers())) continue;
                MethodVisitor visitor = LocalBeanProxyFactory.visit(cw, method, proxyClassFileName, "this$handler");
                visitors.put(method.getName() + Type.getMethodDescriptor((Method)method), visitor);
            }
        }
        DynamicSubclass.copyClassAnnotations(classToProxy, (ClassVisitor)cw);
        DynamicSubclass.copyMethodAnnotations(classToProxy, visitors);
        for (MethodVisitor visitor : visitors.values()) {
            visitor.visitEnd();
        }
        return cw.toByteArray();
    }

    private static MethodVisitor visitConstructor(ClassWriter cw, String proxyClassFileName, String classFileName, Constructor<?> constructor) {
        String descriptor = Type.getConstructorDescriptor(constructor);
        String[] exceptions = new String[constructor.getExceptionTypes().length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = Type.getInternalName(constructor.getExceptionTypes()[i]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor, null, exceptions);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        int index = 1;
        for (Type type : Type.getArgumentTypes((String)descriptor)) {
            mv.visitVarInsn(type.getOpcode(21), index);
            index += DynamicSubclass.size(type);
        }
        mv.visitMethodInsn(183, classFileName, "<init>", descriptor, false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(181, proxyClassFileName, "this$handler", "Ljava/lang/reflect/InvocationHandler;");
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        return mv;
    }

    private static String getSubclassName(Class<?> classToProxy) {
        return classToProxy.getName() + IMPL_SUFFIX;
    }

    private static void getNonPrivateMethods(Class<?> impl, Map<String, List<Method>> methodMap) {
        Class<?>[] interfaces = impl.getInterfaces();
        ArrayList api = new ArrayList(interfaces.length + 1);
        api.add(impl);
        api.addAll(Arrays.asList(interfaces));
        Iterator iterator = api.iterator();
        while (iterator.hasNext()) {
            for (Class clazz = (Class)iterator.next(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Method method : clazz.getDeclaredMethods()) {
                    int modifiers = method.getModifiers();
                    if (Modifier.isFinal(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers)) continue;
                    List<Method> methods = methodMap.get(method.getName());
                    if (methods == null) {
                        methods = new ArrayList<Method>();
                        methods.add(method);
                        methodMap.put(method.getName(), methods);
                        continue;
                    }
                    if (DynamicSubclass.isOverridden(methods, method)) continue;
                    methods.add(method);
                }
            }
        }
    }

    private static boolean isOverridden(List<Method> methods, Method method) {
        for (Method m : methods) {
            if (!Arrays.equals(m.getParameterTypes(), method.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    public static int size(Type type) {
        if (Type.VOID_TYPE.equals((Object)type)) {
            return 0;
        }
        if (Type.LONG_TYPE.equals((Object)type) || Type.DOUBLE_TYPE.equals((Object)type)) {
            return 2;
        }
        return 1;
    }

    public static byte[] readClassFile(Class clazz) throws IOException {
        return DynamicSubclass.readClassFile(clazz.getClassLoader(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readClassFile(ClassLoader classLoader, Class clazz) throws IOException {
        ByteArrayOutputStream out;
        String internalName = clazz.getName().replace('.', '/') + ".class";
        URL resource = classLoader.getResource(internalName);
        InputStream in = IO.read(resource);
        try {
            out = new ByteArrayOutputStream();
            IO.copy(in, (OutputStream)out);
        }
        finally {
            IO.close(in);
        }
        return out.toByteArray();
    }

    private static void copyMethodAnnotations(Class<?> classToProxy, Map<String, MethodVisitor> visitors) throws ProxyGenerationException {
        for (Class<?> clazz = classToProxy; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            try {
                ClassReader classReader = new ClassReader(DynamicSubclass.readClassFile(clazz));
                CopyMethodAnnotations copyMethodAnnotations = new CopyMethodAnnotations(visitors);
                classReader.accept((ClassVisitor)copyMethodAnnotations, 1);
                continue;
            }
            catch (IOException e) {
                throw new ProxyGenerationException(e);
            }
        }
    }

    private static void copyClassAnnotations(Class<?> clazz, ClassVisitor newClass) throws ProxyGenerationException {
        try {
            ClassReader classReader = new ClassReader(DynamicSubclass.readClassFile(clazz));
            CopyClassAnnotations visitor = new CopyClassAnnotations(newClass);
            classReader.accept((ClassVisitor)visitor, 1);
        }
        catch (IOException e) {
            throw new ProxyGenerationException(e);
        }
    }

    private static class CopyMethodAnnotations
    extends ClassVisitor {
        private final Map<String, MethodVisitor> visitors;

        public CopyMethodAnnotations(Map<String, MethodVisitor> visitors) {
            super(327680);
            this.visitors = visitors;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor newMethod = this.visitors.remove(name + desc);
            if (newMethod == null) {
                return null;
            }
            MethodVisitor oldMethod = super.visitMethod(access, name, desc, signature, exceptions);
            return new MoveAnnotationsVisitor(oldMethod, newMethod);
        }
    }

    private static class CopyClassAnnotations
    extends ClassVisitor {
        private final ClassVisitor newClass;

        public CopyClassAnnotations(ClassVisitor newClass) {
            super(327680);
            this.newClass = newClass;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.newClass.visitAnnotation(desc, visible);
        }
    }

    public static class MoveAnnotationsVisitor
    extends MethodVisitor {
        private final MethodVisitor newMethod;

        public MoveAnnotationsVisitor(MethodVisitor movedMethod, MethodVisitor newMethod) {
            super(327680, movedMethod);
            this.newMethod = newMethod;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.newMethod.visitAnnotation(desc, visible);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return this.newMethod.visitParameterAnnotation(parameter, desc, visible);
        }

        public void visitEnd() {
            this.newMethod.visitEnd();
            super.visitEnd();
        }
    }
}

