/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.MethodContext;
import org.apache.openejb.ModuleContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.TimerServiceImpl;
import org.apache.openejb.core.timer.TimerServiceWrapper;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public final class Timers {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.TIMER, TimerServiceWrapper.class);

    private Timers() {
    }

    public static Collection<Timer> all() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        BeanContext beanContext = threadContext.getBeanContext();
        ModuleContext module = beanContext.getModuleContext();
        HashSet<Timer> timers = new HashSet<Timer>();
        for (BeanContext c : module.getAppContext().getBeanContexts()) {
            Collection beanTimers;
            TimerService timerService;
            if (c.getModuleContext() != module) continue;
            if (c.getComponentType() != BeanType.STATEFUL) {
                timerService = Timers.getTimerService(null, c, true);
                if (timerService == null) continue;
                beanTimers = timerService.getTimers();
                timers.addAll(beanTimers);
                continue;
            }
            timerService = Timers.getTimerService(null, c, true);
            if (timerService == null) continue;
            beanTimers = timerService.getTimers();
            timers.addAll(beanTimers);
        }
        return timers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerService getTimerService(Object pk, BeanContext beanContext, boolean nullIfNotRelevant) throws IllegalStateException {
        EjbTimerService timerService = beanContext.getEjbTimerService();
        if (timerService == null) {
            throw new IllegalStateException("This ejb does not support timers " + beanContext.getDeploymentID());
        }
        if (beanContext.getEjbTimeout() == null) {
            HasSchedule hasSchedule = beanContext.get(HasSchedule.class);
            boolean hasSchedules = false;
            if (hasSchedule != null) {
                hasSchedules = hasSchedule.value;
            } else {
                Iterator<Map.Entry<Method, MethodContext>> it = beanContext.iteratorMethodContext();
                while (it.hasNext()) {
                    Map.Entry<Method, MethodContext> entry = it.next();
                    MethodContext methodContext = entry.getValue();
                    if (methodContext.getSchedules().size() <= 0) continue;
                    hasSchedules = true;
                }
                BeanContext beanContext2 = beanContext;
                synchronized (beanContext2) {
                    if (beanContext.get(HasSchedule.class) == null) {
                        beanContext.set(HasSchedule.class, new HasSchedule(hasSchedules));
                    }
                }
            }
            if (!hasSchedules) {
                if (nullIfNotRelevant) {
                    return null;
                }
                LOGGER.error("This ejb does not support timers " + beanContext.getDeploymentID() + " due to no timeout method nor schedules in methodContext is configured");
            }
        }
        return new TimerServiceImpl(timerService, pk, beanContext.getEjbTimeout());
    }

    private static final class HasSchedule {
        private final boolean value;

        private HasSchedule(boolean value) {
            this.value = value;
        }
    }
}

