/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.ObjectFactory;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.core.ivm.naming.ContextualJndiReference;
import org.apache.openejb.core.ivm.naming.JndiEncArtifact;
import org.apache.openejb.core.ivm.naming.NameNode;
import org.apache.openejb.core.ivm.naming.ParsedName;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.core.ivm.naming.java.javaURLContextFactory;
import org.apache.openejb.core.ivm.naming.openejb.openejbURLContextFactory;
import org.apache.openejb.loader.IO;
import org.apache.xbean.naming.context.ContextUtil;

public class IvmContext
implements Context,
Serializable {
    private static final long serialVersionUID = -626353930051783641L;
    Hashtable<String, Object> myEnv;
    boolean readOnly;
    Map<String, Object> fastCache = new ConcurrentHashMap<String, Object>();
    public NameNode mynode;
    static ObjectFactory[] federatedFactories;

    public static IvmContext createRootContext() {
        return new IvmContext();
    }

    public IvmContext() {
        this(new NameNode(null, new ParsedName(""), null, null));
    }

    public IvmContext(String nodeName) {
        this(new NameNode(null, new ParsedName(nodeName), null, null));
    }

    public IvmContext(NameNode node) {
        this.mynode = node;
    }

    public IvmContext(Hashtable<String, Object> environment) throws NamingException {
        this();
        if (environment == null) {
            throw new NamingException("Invalid Argument");
        }
        this.myEnv = (Hashtable)environment.clone();
    }

    @Override
    public Object lookup(String compositName) throws NamingException {
        if (compositName.equals("")) {
            return this;
        }
        int index = compositName.indexOf(":");
        if (index > -1) {
            String prefix = compositName.substring(0, index);
            String path = compositName.substring(index + 1);
            ParsedName name = new ParsedName(path);
            if (prefix.equals("openejb")) {
                path = name.path();
                return openejbURLContextFactory.getContext().lookup(path);
            }
            if (prefix.equals("java")) {
                if (name.getComponent().equals("openejb")) {
                    path = name.remaining().path();
                    return openejbURLContextFactory.getContext().lookup(path);
                }
                path = name.path();
                return javaURLContextFactory.getContext().lookup(path);
            }
            throw new NamingException("Unknown JNDI name prefix '" + prefix + ":'");
        }
        String compoundName = this.mynode.getAtomicName() + '/' + compositName;
        Object obj = this.fastCache.get(compoundName);
        if (obj == null) {
            try {
                obj = this.mynode.resolve(new ParsedName(compoundName));
            }
            catch (NameNotFoundException nnfe) {
                obj = this.federate(compositName);
            }
            if (!(obj instanceof IntraVmProxy) && !(obj instanceof ContextualJndiReference)) {
                this.fastCache.put(compoundName, obj);
            }
        }
        if (obj == null) {
            throw new NameNotFoundException("Name \"" + compositName + "\" not found.");
        }
        if (obj.getClass() == IvmContext.class) {
            ((IvmContext)obj).myEnv = this.myEnv;
        } else if (obj instanceof Reference) {
            obj = ((Reference)((Object)obj)).getObject();
        } else if (obj instanceof LinkRef) {
            obj = this.lookup(((LinkRef)obj).getLinkName());
        }
        return obj;
    }

    protected Object federate(String compositName) throws NamingException {
        ObjectFactory[] factories;
        for (ObjectFactory factory : factories = IvmContext.getFederatedFactories()) {
            try {
                CompositeName name = new CompositeName(compositName);
                Object obj = factory.getObjectInstance(null, name, null, null);
                if (obj instanceof Context) {
                    return ((Context)obj).lookup(compositName);
                }
                if (obj == null) continue;
                return obj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new NameNotFoundException("Name \"" + compositName + "\" not found.");
    }

    public static ObjectFactory[] getFederatedFactories() throws NamingException {
        if (federatedFactories == null) {
            HashSet<ObjectFactory> factories = new HashSet<ObjectFactory>();
            String urlPackagePrefixes = IvmContext.getUrlPackagePrefixes();
            if (urlPackagePrefixes == null) {
                return new ObjectFactory[0];
            }
            StringTokenizer tokenizer = new StringTokenizer(urlPackagePrefixes, ":");
            while (tokenizer.hasMoreTokens()) {
                String urlPackagePrefix = tokenizer.nextToken();
                String className = urlPackagePrefix + ".java.javaURLContextFactory";
                if (className.equals("org.apache.openejb.core.ivm.naming.java.javaURLContextFactory")) continue;
                try {
                    ClassLoader cl = ClassLoaderUtil.getContextClassLoader();
                    Class<?> factoryClass = Class.forName(className, true, cl);
                    ObjectFactory factoryInstance = (ObjectFactory)factoryClass.newInstance();
                    factories.add(factoryInstance);
                }
                catch (ClassNotFoundException cl) {
                }
                catch (Throwable e) {
                    NamingException ne = new NamingException("Federation failed: Cannot instantiate " + className);
                    ne.setRootCause(e);
                    throw ne;
                }
            }
            Object[] temp = factories.toArray();
            federatedFactories = new ObjectFactory[temp.length];
            System.arraycopy(temp, 0, federatedFactories, 0, federatedFactories.length);
        }
        return federatedFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUrlPackagePrefixes() {
        String javahome;
        String urlPackagePrefixes = System.getProperty("java.naming.factory.url.pkgs");
        if (urlPackagePrefixes == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            try {
                Enumeration<URL> resources = classLoader.getResources("jndi.properties");
                while (urlPackagePrefixes == null && resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    InputStream in = IO.read(resource);
                    urlPackagePrefixes = IvmContext.getUrlPackagePrefixes(in);
                }
            }
            catch (IOException resources) {
                // empty catch block
            }
        }
        if (urlPackagePrefixes == null && (javahome = System.getProperty("java.home")) != null) {
            InputStream in = null;
            try {
                File propertiesFile = new File(new File(javahome, "lib"), "jndi.properties");
                in = IO.read(propertiesFile);
                urlPackagePrefixes = IvmContext.getUrlPackagePrefixes(in);
            }
            catch (FileNotFoundException fileNotFoundException) {
                IO.close(in);
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
            IO.close(in);
        }
        return urlPackagePrefixes;
    }

    private static String getUrlPackagePrefixes(InputStream in) {
        try {
            Properties properties = IO.readProperties(in, new Properties());
            return properties.getProperty("java.naming.factory.url.pkgs");
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object lookup(Name compositName) throws NamingException {
        return this.lookup(compositName.toString());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.checkReadOnly();
        int indx = name.indexOf(":");
        if (indx > -1) {
            name = name.substring(indx + 1);
        }
        if (this.fastCache.containsKey(name)) {
            throw new NameAlreadyBoundException();
        }
        ParsedName parsedName = new ParsedName(name);
        this.mynode.bind(parsedName, obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        try {
            this.unbind(name);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.bind(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.checkReadOnly();
        int indx = name.indexOf(":");
        if (indx > -1) {
            name = name.substring(indx + 1);
        }
        this.fastCache.clear();
        this.mynode.clearCache();
        this.mynode.unbind(new ParsedName(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void prune(String name) throws NamingException {
        IvmContext ctx = (IvmContext)this.lookup(name);
        ctx.prune();
    }

    public void prune() throws NamingException {
        this.mynode.prune();
    }

    @Override
    public void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj.getClass() == IvmContext.class) {
            return new MyListEnumeration(((IvmContext)obj).mynode);
        }
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj.getClass() == IvmContext.class) {
            return new MyBindingEnumeration(((IvmContext)obj).mynode);
        }
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        this.checkReadOnly();
        int indx = name.indexOf(":");
        if (indx > -1) {
            name = name.substring(indx + 1);
        }
        if (this.fastCache.containsKey(name)) {
            throw new NameAlreadyBoundException();
        }
        return this.mynode.createSubcontext(new ParsedName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return ContextUtil.NAME_PARSER;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5);
        }
        return this.myEnv.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(3);
        }
        return (Hashtable)this.myEnv.clone();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    @Override
    public void close() throws NamingException {
    }

    protected void checkReadOnly() throws OperationNotSupportedException {
        if (this.readOnly) {
            throw new OperationNotSupportedException();
        }
    }

    public void tree(PrintStream out) {
        this.mynode.tree("", out);
    }

    public String toString() {
        return "IvmContext{mynode=" + this.mynode.getAtomicName() + '}';
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return new JndiEncArtifact(this);
        }
        if (IntraVmCopyMonitor.isCrossClassLoaderOperation()) {
            return new JndiEncArtifact(this);
        }
        throw new NotSerializableException("IntraVM java.naming.Context objects can not be passed as arguments");
    }

    protected abstract class MyNamingEnumeration
    implements NamingEnumeration {
        Enumeration myEnum;

        public MyNamingEnumeration(NameNode parentNode) {
            Vector<NameNode> vect = new Vector<NameNode>();
            NameNode node = parentNode.getSubTree();
            if (node == null) {
                node = parentNode;
            } else {
                vect.addElement(node);
            }
            this.gatherNodes(node, vect);
            this.buildEnumeration(vect);
        }

        protected abstract void buildEnumeration(Vector<NameNode> var1);

        protected void gatherNodes(NameNode node, Vector vect) {
            if (node.getLessTree() != null) {
                vect.addElement(node.getLessTree());
                this.gatherNodes(node.getLessTree(), vect);
            }
            if (node.getGrtrTree() != null) {
                vect.addElement(node.getGrtrTree());
                this.gatherNodes(node.getGrtrTree(), vect);
            }
        }

        @Override
        public void close() {
            this.myEnum = null;
        }

        @Override
        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public Object next() {
            return this.nextElement();
        }

        @Override
        public boolean hasMoreElements() {
            return this.myEnum.hasMoreElements();
        }

        @Override
        public Object nextElement() {
            return this.myEnum.nextElement();
        }
    }

    protected class MyListEnumeration
    extends MyNamingEnumeration {
        public MyListEnumeration(NameNode parentNode) {
            super(parentNode);
        }

        protected void buildEnumeration(Vector vect) {
            for (int i = 0; i < vect.size(); ++i) {
                NameNode node = (NameNode)vect.elementAt(i);
                String className = node.getBinding().getClass().getName();
                vect.setElementAt(new NameClassPair(node.getAtomicName(), className), i);
            }
            this.myEnum = vect.elements();
        }
    }

    protected class MyBindingEnumeration
    extends MyNamingEnumeration {
        public MyBindingEnumeration(NameNode parentNode) {
            super(parentNode);
        }

        protected void buildEnumeration(Vector vect) {
            for (int i = 0; i < vect.size(); ++i) {
                NameNode node = (NameNode)vect.elementAt(i);
                String className = node.getBinding().getClass().getName();
                vect.setElementAt(new Binding(node.getAtomicName(), className, node.getBinding()), i);
            }
            this.myEnum = vect.elements();
        }
    }
}

