/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.apache.openejb.cdi.CdiPlugin;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.classloader.ClassLoaderAwareHandler;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;

public class OptimizedLoaderService
implements LoaderService {
    private static final Logger log = Logger.getInstance(LogCategory.OPENEJB.createChild("cdi"), OptimizedLoaderService.class);
    public static final ThreadLocal<Collection<String>> ADDITIONAL_EXTENSIONS = new ThreadLocal();
    private final LoaderService loaderService;

    public OptimizedLoaderService() {
        this((LoaderService)new DefaultLoaderService());
    }

    public OptimizedLoaderService(LoaderService loaderService) {
        this.loaderService = loaderService;
    }

    public <T> List<T> load(Class<T> serviceType) {
        return this.load(serviceType, Thread.currentThread().getContextClassLoader());
    }

    public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        if (OpenWebBeansPlugin.class.equals(serviceType)) {
            return this.loadWebBeansPlugins(classLoader);
        }
        if (Extension.class.equals(serviceType)) {
            return this.loadExtensions(classLoader);
        }
        return this.loaderService.load(serviceType, classLoader);
    }

    protected List<? extends Extension> loadExtensions(ClassLoader classLoader) {
        List list = this.loaderService.load(Extension.class, classLoader);
        Collection<String> additional = ADDITIONAL_EXTENSIONS.get();
        if (additional != null) {
            for (String name : additional) {
                try {
                    list.add(Extension.class.cast(classLoader.loadClass(name).newInstance()));
                }
                catch (Exception exception) {}
            }
        }
        ArrayList<Extension> extensionCopy = new ArrayList<Extension>(list);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (!it.hasNext() || !this.isFiltered(extensionCopy, (Extension)it.next())) continue;
            it.remove();
        }
        return list;
    }

    private boolean isFiltered(Collection<Extension> extensions, Extension next) {
        String name;
        ClassLoader containerLoader = ParentClassLoaderFinder.Helper.get();
        Class<?> extClass = next.getClass();
        if (extClass.getClassLoader() != containerLoader) {
            return false;
        }
        switch (name = extClass.getName()) {
            case "org.apache.bval.cdi.BValExtension": {
                for (Extension e : extensions) {
                    String en = e.getClass().getName();
                    if (!en.startsWith("org.hibernate.validator.") || !en.endsWith("ValidationExtension")) continue;
                    log.info("Skipping BVal CDI integration cause hibernate was found in the application");
                    return true;
                }
                break;
            }
            case "org.apache.batchee.container.cdi.BatchCDIInjectionExtension": {
                return "true".equals(SystemInstance.get().getProperty("tomee.batchee.cdi.use-extension", "false"));
            }
            case "org.apache.commons.jcs.jcache.cdi.MakeJCacheCDIInterceptorFriendly": {
                String spi = "META-INF/services/javax.cache.spi.CachingProvider";
                try {
                    Enumeration<URL> appResources = Thread.currentThread().getContextClassLoader().getResources("META-INF/services/javax.cache.spi.CachingProvider");
                    if (appResources == null || !appResources.hasMoreElements()) break;
                    ArrayList<URL> containerResources = Collections.list(containerLoader.getResources("META-INF/services/javax.cache.spi.CachingProvider"));
                    do {
                        if (containerResources.contains(appResources.nextElement())) continue;
                        log.info("Skipping JCS CDI integration cause another provide was found in the application");
                        return true;
                    } while (appResources.hasMoreElements());
                }
                catch (Exception exception) {}
                break;
            }
        }
        return false;
    }

    private List<? extends OpenWebBeansPlugin> loadWebBeansPlugins(ClassLoader loader) {
        Class<?> clazz;
        ArrayList<CdiPlugin> list = new ArrayList<CdiPlugin>(2);
        list.add(new CdiPlugin());
        try {
            clazz = loader.loadClass("org.apache.geronimo.openejb.cdi.GeronimoWebBeansPlugin");
            try {
                list.add((CdiPlugin)((Object)OpenWebBeansPlugin.class.cast(clazz.newInstance())));
            }
            catch (Exception e) {
                log.error("Unable to load OpenWebBeansPlugin: GeronimoWebBeansPlugin");
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            clazz = loader.loadClass("org.apache.webbeans.jsf.plugin.OpenWebBeansJsfPlugin");
            try {
                list.add((CdiPlugin)((Object)OpenWebBeansPlugin.class.cast(Proxy.newProxyInstance(loader, new Class[]{OpenWebBeansPlugin.class}, (InvocationHandler)new ClassLoaderAwareHandler(clazz.getSimpleName(), clazz.newInstance(), loader)))));
            }
            catch (Exception e) {
                log.error("Unable to load OpenWebBeansPlugin: OpenWebBeansJsfPlugin");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return list;
    }
}

