/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Valid;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import javax.validation.groups.ConvertGroup;
import javax.validation.groups.Default;
import org.apache.bval.jsr.AnnotationConstraintBuilder;
import org.apache.bval.jsr.AnnotationProcessor$org_apache_bval_util_reflection_Reflection$$getAnnotationValue$$Ljava_lang_annotation_Annotation$Ljava_lang_String$_ACTION;
import org.apache.bval.jsr.AnnotationProcessor$org_apache_bval_util_reflection_Reflection$$setAccessible$$Ljava_lang_reflect_AccessibleObject$Z_ACTION;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.AppendValidation;
import org.apache.bval.jsr.AppendValidationToBuilder;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.ParametersAccess;
import org.apache.bval.jsr.ReturnAccess;
import org.apache.bval.model.Meta;
import org.apache.bval.model.MetaBean;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public final class AnnotationProcessor {
    private final ApacheValidatorFactory factory;

    public AnnotationProcessor(ApacheValidatorFactory factory) {
        this.factory = factory;
    }

    public boolean processAnnotations(Meta prop, Class<?> owner, AnnotatedElement element, AccessStrategy access, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        boolean changed = false;
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (type.getName().startsWith("java.lang.annotation.")) continue;
            changed = this.processAnnotation(annotation, prop, owner, access, appender, true) || changed;
        }
        return changed;
    }

    public <A extends Annotation> boolean processAnnotation(A annotation, Meta prop, Class<?> owner, AccessStrategy access, AppendValidation appender, boolean reflection) throws IllegalAccessException, InvocationTargetException {
        if (annotation instanceof Valid) {
            return this.addAccessStrategy(prop, access);
        }
        if (ConvertGroup.class.isInstance(annotation) || ConvertGroup.List.class.isInstance(annotation)) {
            if (!reflection) {
                ArrayList<A> annotations = (ArrayList<A>)prop.getFeature("annotationToProcess");
                if (annotations == null) {
                    annotations = new ArrayList<A>();
                    prop.putFeature("annotationToProcess", annotations);
                }
                annotations.add(annotation);
            }
            return true;
        }
        Constraint vcAnno = annotation.annotationType().getAnnotation(Constraint.class);
        if (vcAnno != null) {
            Class<ConstraintValidator<A, ?>>[] validatorClasses = this.findConstraintValidatorClasses(annotation, vcAnno);
            return this.applyConstraint(annotation, validatorClasses, prop, owner, access, appender);
        }
        Object result = AnnotationProcessor.org_apache_bval_util_reflection_Reflection$$getAnnotationValue(annotation, ConstraintAnnotationAttributes.VALUE.getAttributeName());
        if (result instanceof Annotation[]) {
            boolean changed = false;
            for (Annotation each : (Annotation[])result) {
                if (each.annotationType().getName().startsWith("java.lang.annotation")) continue;
                changed |= this.processAnnotation(each, prop, owner, access, appender, reflection);
            }
            return changed;
        }
        return false;
    }

    @Privileged
    private static /* synthetic */ boolean org_apache_bval_util_reflection_Reflection$$setAccessible(AccessibleObject accessibleObject, boolean bl) {
        if (!(System.getSecurityManager() != null)) {
            return AnnotationProcessor.__privileged_org_apache_bval_util_reflection_Reflection$$setAccessible(accessibleObject, bl);
        }
        return (Boolean)AccessController.doPrivileged(new AnnotationProcessor$org_apache_bval_util_reflection_Reflection$$setAccessible$$Ljava_lang_reflect_AccessibleObject$Z_ACTION(accessibleObject, bl));
    }

    static /* synthetic */ boolean __privileged_access$0(AccessibleObject accessibleObject, boolean bl) {
        return AnnotationProcessor.__privileged_org_apache_bval_util_reflection_Reflection$$setAccessible(accessibleObject, bl);
    }

    private static /* synthetic */ boolean __privileged_org_apache_bval_util_reflection_Reflection$$setAccessible(AccessibleObject accessibleObject, boolean bl) {
        if (accessibleObject == null || accessibleObject.isAccessible() == bl) {
            return false;
        }
        if (!bl && System.getSecurityManager() == null) {
            return false;
        }
        Member member = (Member)((Object)accessibleObject);
        if (Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
            return false;
        }
        accessibleObject.setAccessible(bl);
        return true;
    }

    @Privileged
    private static /* synthetic */ Object org_apache_bval_util_reflection_Reflection$$getAnnotationValue(Annotation annotation, String string) throws IllegalAccessException, InvocationTargetException {
        if (!(System.getSecurityManager() != null)) {
            return AnnotationProcessor.__privileged_org_apache_bval_util_reflection_Reflection$$getAnnotationValue(annotation, string);
        }
        try {
            return AccessController.doPrivileged(new AnnotationProcessor$org_apache_bval_util_reflection_Reflection$$getAnnotationValue$$Ljava_lang_annotation_Annotation$Ljava_lang_String$_ACTION(annotation, string));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    static /* synthetic */ Object __privileged_access$1(Annotation annotation, String string) throws Exception {
        return AnnotationProcessor.__privileged_org_apache_bval_util_reflection_Reflection$$getAnnotationValue(annotation, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Object __privileged_org_apache_bval_util_reflection_Reflection$$getAnnotationValue(Annotation annotation, String string) throws IllegalAccessException, InvocationTargetException {
        Method method;
        try {
            method = annotation.annotationType().getDeclaredMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        boolean bl = AnnotationProcessor.__privileged_org_apache_bval_util_reflection_Reflection$$setAccessible(method, true);
        try {
            Object object = method.invoke((Object)annotation, new Object[0]);
            return object;
        }
        finally {
            if (bl) {
                AnnotationProcessor.__privileged_org_apache_bval_util_reflection_Reflection$$setAccessible(method, false);
            }
        }
    }

    public boolean addAccessStrategy(Meta prop, AccessStrategy access) {
        if (prop == null) {
            return false;
        }
        Object[] strategies = (AccessStrategy[])prop.getFeature("refCascade");
        if (ArrayUtils.contains((Object[])strategies, (Object)access)) {
            return false;
        }
        strategies = strategies == null ? new AccessStrategy[]{access} : (AccessStrategy[])ArrayUtils.add((Object[])strategies, (Object)access);
        prop.putFeature("refCascade", (Object)strategies);
        return true;
    }

    private <A extends Annotation> Class<? extends ConstraintValidator<A, ?>>[] findConstraintValidatorClasses(A annotation, Constraint vcAnno) {
        if (vcAnno == null) {
            vcAnno = annotation.annotationType().getAnnotation(Constraint.class);
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Class<ConstraintValidator<? extends Annotation, ?>>[] validatorClasses = this.factory.getConstraintsCache().getConstraintValidators(annotationType);
        if (validatorClasses == null && (validatorClasses = vcAnno.validatedBy()).length == 0) {
            validatorClasses = this.factory.getDefaultConstraints().getValidatorClasses(annotationType);
        }
        return validatorClasses;
    }

    private <A extends Annotation> boolean applyConstraint(A annotation, Class<? extends ConstraintValidator<A, ?>>[] rawConstraintClasses, Meta prop, Class<?> owner, AccessStrategy access, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        Class<ConstraintValidator<A, ?>>[] constraintClasses = AnnotationProcessor.select(rawConstraintClasses, access);
        if (constraintClasses != null && constraintClasses.length == 0 && rawConstraintClasses.length > 0) {
            return false;
        }
        AnnotationConstraintBuilder<A> builder = new AnnotationConstraintBuilder<A>(constraintClasses, annotation, owner, access, null);
        if (prop != null && prop.getParentMetaBean() != null) {
            MetaBean parentMetaBean = prop.getParentMetaBean();
            if (builder.getConstraintValidation().getOwner().isInterface() && parentMetaBean.getBeanClass() != builder.getConstraintValidation().getOwner() && builder.getConstraintValidation().getGroups().size() == 1 && builder.getConstraintValidation().getGroups().contains(Default.class)) {
                Set<Class<?>> groups = builder.getConstraintValidation().getGroups();
                groups.add(builder.getConstraintValidation().getOwner());
                builder.getConstraintValidation().setGroups(groups);
            }
        }
        if (appender instanceof AppendValidationToBuilder) {
            AppendValidationToBuilder avb = (AppendValidationToBuilder)appender;
            builder.getConstraintValidation().setGroups(avb.getInheritedGroups());
            builder.getConstraintValidation().setPayload(avb.getInheritedPayload());
        }
        this.processAnnotations(prop, owner, annotation.annotationType(), access, new AppendValidationToBuilder(builder));
        appender.append(builder.getConstraintValidation());
        return true;
    }

    private static <A extends Annotation> Class<? extends ConstraintValidator<A, ?>>[] select(Class<? extends ConstraintValidator<A, ?>>[] rawConstraintClasses, AccessStrategy access) {
        boolean isReturn = ReturnAccess.class.isInstance(access);
        boolean isParam = ParametersAccess.class.isInstance(access);
        if (rawConstraintClasses != null && (isReturn || isParam)) {
            ArrayList selected = new ArrayList();
            for (Class<ConstraintValidator<SupportedValidationTarget, ?>> clazz : rawConstraintClasses) {
                SupportedValidationTarget target = clazz.getAnnotation(SupportedValidationTarget.class);
                if (target == null && isReturn) {
                    selected.add(clazz);
                    continue;
                }
                if (target == null) continue;
                for (ValidationTarget validationTarget : target.value()) {
                    if (isReturn && ValidationTarget.ANNOTATED_ELEMENT == validationTarget) {
                        selected.add(clazz);
                        continue;
                    }
                    if (!isParam || ValidationTarget.PARAMETERS != validationTarget) continue;
                    selected.add(clazz);
                }
            }
            Class[] result = selected.toArray(new Class[selected.size()]);
            return result;
        }
        return rawConstraintClasses;
    }
}

