/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.bearer;

import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class BearerAccessToken
extends ServerAccessToken {
    private static final long serialVersionUID = -3614732043728799245L;

    public BearerAccessToken(Client client, long lifetime) {
        super(client, "Bearer", OAuthUtils.generateRandomTokenKey(), lifetime, OAuthUtils.getIssuedAt());
    }

    public BearerAccessToken(Client client, String tokenKey, long lifetime, long issuedAt) {
        super(client, "Bearer", tokenKey, lifetime, issuedAt);
    }

    public BearerAccessToken(ServerAccessToken token) {
        this(token, OAuthUtils.generateRandomTokenKey());
    }

    public BearerAccessToken(ServerAccessToken token, String newKey) {
        super(BearerAccessToken.validateTokenType(token, "Bearer"), newKey);
    }

    public BearerAccessToken() {
    }
}

