/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.common;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;

@XmlRootElement
public class AccessTokenValidation {
    private boolean initialValidationSuccessful = true;
    private String clientId;
    private String clientIpAddress;
    private UserSubject clientSubject;
    private boolean isClientConfidential;
    private String tokenKey;
    private String tokenType;
    private String tokenGrantType;
    private long tokenIssuedAt;
    private long tokenLifetime;
    private String tokenIssuer;
    private UserSubject tokenSubject;
    private List<OAuthPermission> tokenScopes = new LinkedList<OAuthPermission>();
    private List<String> audiences = new LinkedList<String>();
    private String clientCodeVerifier;
    private Map<String, String> extraProps = new HashMap<String, String>();

    public AccessTokenValidation() {
    }

    public AccessTokenValidation(ServerAccessToken token) {
        this.clientId = token.getClient().getClientId();
        this.clientSubject = token.getClient().getSubject();
        this.isClientConfidential = token.getClient().isConfidential();
        this.clientIpAddress = token.getClient().getClientIpAddress();
        this.tokenKey = token.getTokenKey();
        this.tokenType = token.getTokenType();
        this.tokenGrantType = token.getGrantType();
        this.tokenIssuedAt = token.getIssuedAt();
        this.tokenLifetime = token.getExpiresIn();
        this.tokenIssuer = token.getIssuer();
        this.tokenSubject = token.getSubject();
        this.tokenScopes = token.getScopes();
        this.setAudiences(token.getAudiences());
        this.clientCodeVerifier = token.getClientCodeVerifier();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public UserSubject getClientSubject() {
        return this.clientSubject;
    }

    public void setClientSubject(UserSubject clientSubject) {
        this.clientSubject = clientSubject;
    }

    public String getTokenKey() {
        return this.tokenKey;
    }

    public void setTokenKey(String tokenId) {
        this.tokenKey = tokenId;
    }

    public UserSubject getTokenSubject() {
        return this.tokenSubject;
    }

    public void setTokenSubject(UserSubject tokenSubject) {
        this.tokenSubject = tokenSubject;
    }

    public List<OAuthPermission> getTokenScopes() {
        return this.tokenScopes;
    }

    public void setTokenScopes(List<OAuthPermission> tokenPermissions) {
        this.tokenScopes = tokenPermissions;
    }

    public String getTokenGrantType() {
        return this.tokenGrantType;
    }

    public void setTokenGrantType(String tokenGrantType) {
        this.tokenGrantType = tokenGrantType;
    }

    public long getTokenIssuedAt() {
        return this.tokenIssuedAt;
    }

    public void setTokenIssuedAt(long tokenIssuedAt) {
        this.tokenIssuedAt = tokenIssuedAt;
    }

    public long getTokenLifetime() {
        return this.tokenLifetime;
    }

    public void setTokenLifetime(long tokenLifetime) {
        this.tokenLifetime = tokenLifetime;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public Map<String, String> getExtraProps() {
        return this.extraProps;
    }

    public void setExtraProps(Map<String, String> extraProps) {
        this.extraProps = extraProps;
    }

    public boolean isClientConfidential() {
        return this.isClientConfidential;
    }

    public void setClientConfidential(boolean isConfidential) {
        this.isClientConfidential = isConfidential;
    }

    public String getClientCodeVerifier() {
        return this.clientCodeVerifier;
    }

    public void setClientCodeVerifier(String clientCodeVerifier) {
        this.clientCodeVerifier = clientCodeVerifier;
    }

    public boolean isInitialValidationSuccessful() {
        return this.initialValidationSuccessful;
    }

    public void setInitialValidationSuccessful(boolean localValidationSuccessful) {
        this.initialValidationSuccessful = localValidationSuccessful;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public String getTokenIssuer() {
        return this.tokenIssuer;
    }

    public void setTokenIssuer(String tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
    }
}

