/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProducerFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;

public class InjectableBeanManager
implements BeanManager,
Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient BeanManagerImpl bm;

    public InjectableBeanManager() {
        this(WebBeansContext.getInstance().getBeanManagerImpl());
    }

    public InjectableBeanManager(BeanManagerImpl beanManager) {
        this.bm = beanManager;
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        return this.bm.createAnnotatedType(type);
    }

    public <T> CreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        return this.bm.createCreationalContext((Contextual)contextual);
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        return this.bm.createInjectionTarget(type);
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        this.bm.fireEvent(event, qualifiers);
    }

    public Set<Bean<?>> getBeans(String name) {
        this.checkAfterBeanDiscoveryProcessed("It's not allowed to call getBeans(String) before AfterBeanDiscovery");
        return this.bm.getBeans(name);
    }

    public Set<Bean<?>> getBeans(Type beanType, Annotation ... qualifiers) {
        this.checkAfterBeanDiscoveryProcessed("It's not allowed to call getBeans(Type, Annotation...) before AfterBeanDiscovery");
        return this.bm.getBeans(beanType, qualifiers);
    }

    public Context getContext(Class<? extends Annotation> scope) {
        return this.bm.getContext(scope);
    }

    public ELResolver getELResolver() {
        return this.bm.getELResolver();
    }

    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> ctx) {
        this.checkAfterDeploymentValidationFired("It's not allowed to call getInjectableReference(InjectionPoin, CreationalContext) before AfterDeploymentValidation");
        return this.bm.getInjectableReference(injectionPoint, ctx);
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> qualifier) {
        return this.bm.getInterceptorBindingDefinition(qualifier);
    }

    public Bean<?> getPassivationCapableBean(String id) {
        this.checkAfterBeanDiscoveryProcessed("It's not allowed to call getPassivationCapableBean(String) before AfterBeanDiscovery");
        return this.bm.getPassivationCapableBean(id);
    }

    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> ctx) {
        this.checkAfterDeploymentValidationFired("It's not allowed to call getReference(Bean, Type, CreationalContext) before AfterDeploymentValidation");
        return this.bm.getReference(bean, beanType, ctx);
    }

    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        return this.bm.getStereotypeDefinition(stereotype);
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return this.bm.isInterceptorBinding(annotationType);
    }

    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        return this.bm.isNormalScope(annotationType);
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        return this.bm.isPassivatingScope(annotationType);
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return this.bm.isQualifier(annotationType);
    }

    public boolean isScope(Class<? extends Annotation> annotationType) {
        return this.bm.isScope(annotationType);
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return this.bm.isStereotype(annotationType);
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        this.checkAfterBeanDiscoveryProcessed("It's not allowed to call resolve(Set<Bean>) before AfterBeanDiscovery");
        return this.bm.resolve(beans);
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        this.checkAfterBeanDiscoveryProcessed("It's not allowed to call resolveDecorators(Set<Type>, Annotation...) before AfterBeanDiscovery");
        return this.bm.resolveDecorators(types, qualifiers);
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        this.checkAfterBeanDiscoveryProcessed("It's not allowed to call resolveInterceptors(InterceptionType, Annotation...) before AfterBeanDiscovery");
        return this.bm.resolveInterceptors(type, interceptorBindings);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        this.checkAfterBeanDiscoveryProcessed("It's not allowed to call resolveObserverMethods(Object, Annotation...) before AfterBeanDiscovery");
        return this.bm.resolveObserverMethods(event, qualifiers);
    }

    public void validate(InjectionPoint injectionPoint) {
        this.checkAfterBeanDiscoveryProcessed("It's not allowed to call validate(InjectionPoint) before AfterBeanDiscovery");
        this.bm.validate(injectionPoint);
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        return this.bm.wrapExpressionFactory(expressionFactory);
    }

    public boolean areQualifiersEquivalent(Annotation qualifier1, Annotation qualifier2) {
        return this.bm.areQualifiersEquivalent(qualifier1, qualifier2);
    }

    public int getQualifierHashCode(Annotation qualifier) {
        return this.bm.getQualifierHashCode(qualifier);
    }

    public boolean areInterceptorBindingsEquivalent(Annotation interceptorBinding1, Annotation interceptorBinding2) {
        return this.bm.areInterceptorBindingsEquivalent(interceptorBinding1, interceptorBinding2);
    }

    public int getInterceptorBindingHashCode(Annotation interceptorBinding) {
        return this.bm.getInterceptorBindingHashCode(interceptorBinding);
    }

    public InjectionPoint createInjectionPoint(AnnotatedField<?> field) {
        return this.bm.createInjectionPoint(field);
    }

    public InjectionPoint createInjectionPoint(AnnotatedParameter<?> parameter) {
        return this.bm.createInjectionPoint(parameter);
    }

    public <T> InjectionTargetFactory<T> getInjectionTargetFactory(AnnotatedType<T> type) {
        return this.bm.getInjectionTargetFactory(type);
    }

    public <X> ProducerFactory<X> getProducerFactory(AnnotatedField<? super X> field, Bean<X> declaringBean) {
        return this.bm.getProducerFactory(field, declaringBean);
    }

    public <X> ProducerFactory<X> getProducerFactory(AnnotatedMethod<? super X> method, Bean<X> declaringBean) {
        return this.bm.getProducerFactory(method, declaringBean);
    }

    public <T> BeanAttributes<T> createBeanAttributes(AnnotatedType<T> type) {
        return this.bm.createBeanAttributes(type);
    }

    public BeanAttributes<?> createBeanAttributes(AnnotatedMember<?> member) {
        return this.bm.createBeanAttributes(member);
    }

    public <T> Bean<T> createBean(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> injectionTargetFactory) {
        return this.bm.createBean(attributes, beanClass, injectionTargetFactory);
    }

    public <T, X> Bean<T> createBean(BeanAttributes<T> attributes, Class<X> beanClass, ProducerFactory<X> producerFactory) {
        return this.bm.createBean(attributes, beanClass, producerFactory);
    }

    public <T extends Extension> T getExtension(Class<T> extensionClass) {
        return this.bm.getExtension(extensionClass);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bm = WebBeansContext.currentInstance().getBeanManagerImpl();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bm == null ? 0 : System.identityHashCode(this.bm));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InjectableBeanManager other = (InjectableBeanManager)obj;
        return !(this.bm == null ? other.bm != null : System.identityHashCode(this.bm) != System.identityHashCode(other.bm));
    }

    private void checkAfterBeanDiscoveryProcessed(String message) {
        if (!this.bm.isAfterBeanDiscoveryFired()) {
            throw new IllegalStateException(message);
        }
    }

    private void checkAfterDeploymentValidationFired(String message) {
        if (!this.bm.isAfterDeploymentValidationFired()) {
            throw new IllegalStateException(message);
        }
    }
}

