/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class EjbObjectInputStream
extends ObjectInputStream {
    private static final BlacklistClassResolver DEFAULT = new BlacklistClassResolver();

    public EjbObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        String n = DEFAULT.check(classDesc.getName());
        ClassLoader classloader = this.getClassloader();
        try {
            return Class.forName(n, false, classloader);
        }
        catch (ClassNotFoundException e) {
            if (n.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (n.equals("byte")) {
                return Byte.TYPE;
            }
            if (n.equals("char")) {
                return Character.TYPE;
            }
            if (n.equals("short")) {
                return Short.TYPE;
            }
            if (n.equals("int")) {
                return Integer.TYPE;
            }
            if (n.equals("long")) {
                return Long.TYPE;
            }
            if (n.equals("float")) {
                return Float.TYPE;
            }
            if (n.equals("double")) {
                return Double.TYPE;
            }
            return Class.forName(n, false, null);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.getClassloader().loadClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(this.getClassloader(), cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    ClassLoader getClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static class BlacklistClassResolver {
        private static final String[] WHITELIST = BlacklistClassResolver.toArray(System.getProperty("tomee.serialization.class.whitelist"));
        private static final String[] BLACKLIST = BlacklistClassResolver.toArray(System.getProperty("tomee.serialization.class.blacklist", "org.codehaus.groovy.runtime.,org.apache.commons.collections.functors.,org.apache.xalan,java.lang.Process"));
        private final String[] blacklist;
        private final String[] whitelist;

        protected BlacklistClassResolver() {
            this(BLACKLIST, WHITELIST);
        }

        protected BlacklistClassResolver(String[] blacklist, String[] whitelist) {
            this.whitelist = whitelist;
            this.blacklist = blacklist;
        }

        protected boolean isBlacklisted(String name) {
            return this.whitelist != null && !BlacklistClassResolver.contains(this.whitelist, name) || BlacklistClassResolver.contains(this.blacklist, name);
        }

        public final String check(String name) {
            if (this.isBlacklisted(name)) {
                throw new SecurityException(name + " is not whitelisted as deserialisable, prevented before loading.");
            }
            return name;
        }

        private static String[] toArray(String property) {
            return property == null ? null : property.split(" *, *");
        }

        private static boolean contains(String[] list, String name) {
            if (list != null) {
                for (String white : list) {
                    if (!name.startsWith(white)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

