/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.util.Map;
import java.util.Properties;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseType;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsHeaders
extends JoseHeaders {
    private static final long serialVersionUID = 3422779299093961672L;

    public JwsHeaders() {
    }

    public JwsHeaders(JoseType type) {
        super(type);
    }

    public JwsHeaders(JwsHeaders headers) {
        super(headers.asMap());
    }

    public JwsHeaders(Map<String, Object> values) {
        super(values);
    }

    public JwsHeaders(SignatureAlgorithm sigAlgo) {
        this.init(sigAlgo);
    }

    public JwsHeaders(Properties sigProps) {
        this.init(JwsHeaders.getSignatureAlgorithm(sigProps));
    }

    public JwsHeaders(JoseType type, SignatureAlgorithm sigAlgo) {
        super(type);
        this.init(sigAlgo);
    }

    private void init(SignatureAlgorithm sigAlgo) {
        this.setSignatureAlgorithm(sigAlgo);
    }

    public void setSignatureAlgorithm(SignatureAlgorithm algo) {
        super.setAlgorithm(algo.getJwaName());
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        String algo = super.getAlgorithm();
        return algo == null ? null : SignatureAlgorithm.getAlgorithm(algo);
    }

    public void setPayloadEncodingStatus(Boolean status) {
        super.setProperty("b64", (Object)status);
    }

    public Boolean getPayloadEncodingStatus() {
        return super.getBooleanProperty("b64");
    }

    private static SignatureAlgorithm getSignatureAlgorithm(Properties sigProps) {
        return JwsUtils.getSignatureAlgorithm(sigProps, null);
    }
}

