/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.httpd.ServletResponseAdapter;
import org.apache.openejb.server.webservices.WsConstants;

public class WsServlet
implements Servlet {
    public static final String POJO_CLASS = WsServlet.class.getName() + "@pojoClassName";
    public static final String WEBSERVICE_CONTAINER = WsServlet.class.getName() + "@WebServiceContainer";
    private static final DefaultContext DEFAULT_CONTEXT = new DefaultContext();
    private static final ThreadLocal<ServletEndpointContext> endpointContext = new ThreadLocal();
    private ServletConfig config;
    private Object pojo;
    private HttpListener service;

    public WsServlet() {
    }

    public WsServlet(HttpListener service) {
        this.service = service;
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.pojo = this.createPojoInstance();
        if (this.pojo instanceof ServiceLifecycle) {
            try {
                ((ServiceLifecycle)this.pojo).init((Object)new InstanceContext(config.getServletContext()));
            }
            catch (ServiceException e) {
                throw new ServletException("Unable to initialize ServiceEndpoint", (Throwable)e);
            }
        }
        this.getService();
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "Webservice Servlet " + this.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpListener service = this.getService();
        if (service == null) {
            throw new ServletException("WebServiceContainer has not been set");
        }
        ServletEndpointContext context = WsServlet.getContext();
        endpointContext.set(new InvocationContext((HttpServletRequest)req));
        try {
            res.setContentType("text/xml");
            ServletRequestAdapter httpRequest = new ServletRequestAdapter((HttpServletRequest)req, (HttpServletResponse)res, this.config.getServletContext());
            ServletResponseAdapter httpResponse = new ServletResponseAdapter((HttpServletResponse)res);
            if (this.pojo != null) {
                req.setAttribute(WsConstants.POJO_INSTANCE, this.pojo);
            }
            try {
                service.onMessage((HttpRequest)httpRequest, (HttpResponse)httpResponse);
            }
            catch (IOException | ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException("Error processing webservice request", (Throwable)e);
            }
        }
        finally {
            endpointContext.set(context);
        }
    }

    public void destroy() {
        if (this.pojo instanceof ServiceLifecycle) {
            ((ServiceLifecycle)this.pojo).destroy();
        }
    }

    private Object createPojoInstance() throws ServletException {
        ServletContext context = this.getServletConfig().getServletContext();
        String pojoClassId = context.getInitParameter(POJO_CLASS);
        if (pojoClassId == null) {
            return null;
        }
        Class pojoClass = (Class)context.getAttribute(pojoClassId);
        if (pojoClass == null) {
            return null;
        }
        try {
            Object instance = pojoClass.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new ServletException("Unable to instantiate POJO WebService class: " + pojoClass.getName(), (Throwable)e);
        }
    }

    private synchronized HttpListener getService() {
        ServletConfig config;
        String webServiceContainerId;
        if (this.service == null && (webServiceContainerId = (config = this.getServletConfig()).getInitParameter(WEBSERVICE_CONTAINER)) != null) {
            this.service = (HttpListener)config.getServletContext().getAttribute(webServiceContainerId);
        }
        return this.service;
    }

    private static ServletEndpointContext getContext() {
        ServletEndpointContext context = endpointContext.get();
        return context != null ? context : DEFAULT_CONTEXT;
    }

    private static class DefaultContext
    implements ServletEndpointContext {
        private DefaultContext() {
        }

        public MessageContext getMessageContext() {
            throw new IllegalStateException("Method cannot be called outside a request context");
        }

        public Principal getUserPrincipal() {
            throw new IllegalStateException("Method cannot be called outside a request context");
        }

        public HttpSession getHttpSession() {
            throw new JAXRPCException("Method cannot be called outside an http request context");
        }

        public ServletContext getServletContext() {
            throw new IllegalAccessError("InstanceContext should never delegate this method.");
        }

        public boolean isUserInRole(String s) {
            throw new IllegalStateException("Method cannot be called outside a request context");
        }
    }

    private static class InvocationContext
    implements ServletEndpointContext {
        private final HttpServletRequest request;

        public InvocationContext(HttpServletRequest request) {
            this.request = request;
        }

        public MessageContext getMessageContext() {
            return (MessageContext)this.request.getAttribute(WsConstants.MESSAGE_CONTEXT);
        }

        public Principal getUserPrincipal() {
            return this.request.getUserPrincipal();
        }

        public HttpSession getHttpSession() {
            return this.request.getSession();
        }

        public ServletContext getServletContext() {
            throw new IllegalAccessError("InstanceContext should never delegate this method.");
        }

        public boolean isUserInRole(String s) {
            return this.request.isUserInRole(s);
        }
    }

    private static class InstanceContext
    implements ServletEndpointContext {
        private final ServletContext servletContext;

        public InstanceContext(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public MessageContext getMessageContext() {
            return WsServlet.getContext().getMessageContext();
        }

        public Principal getUserPrincipal() {
            return WsServlet.getContext().getUserPrincipal();
        }

        public HttpSession getHttpSession() {
            return WsServlet.getContext().getHttpSession();
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public boolean isUserInRole(String s) {
            return WsServlet.getContext().isUserInRole(s);
        }
    }
}

