/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class AbstractJwsJsonReaderProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJwsJsonReaderProvider.class);
    private List<JwsSignatureVerifier> sigVerifiers;
    private String defaultMediaType;
    private boolean strictVerification;

    public void setSignatureVerifier(JwsSignatureVerifier signatureVerifier) {
        this.setSignatureVerifiers(Collections.singletonList(signatureVerifier));
    }

    public void setSignatureVerifiers(List<JwsSignatureVerifier> signatureVerifiers) {
        this.sigVerifiers = signatureVerifiers;
    }

    protected List<JwsSignatureVerifier> getInitializedSigVerifiers() {
        if (this.sigVerifiers != null) {
            return this.sigVerifiers;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        Object propLocsProp = MessageUtils.getContextualProperty((Message)m, (String)"rs.security.signature.in.list.properties", (String)"rs.security.signature.list.properties");
        if (propLocsProp == null) {
            LOG.warning("JWS JSON init properties resource is not identified");
            throw new JwsException(JwsException.Error.NO_INIT_PROPERTIES);
        }
        List<String> propLocs = null;
        if (propLocsProp instanceof String) {
            String[] props = ((String)propLocsProp).split(",");
            propLocs = Arrays.asList(props);
        } else {
            propLocs = CastUtils.cast((List)((List)propLocsProp));
        }
        LinkedList<JwsSignatureVerifier> theSigVerifiers = new LinkedList<JwsSignatureVerifier>();
        for (String propLoc : propLocs) {
            theSigVerifiers.addAll(JwsUtils.loadSignatureVerifiers((String)propLoc, (Message)m));
        }
        return theSigVerifiers;
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    public boolean isStrictVerification() {
        return this.strictVerification;
    }

    public void setStrictVerification(boolean strictVerification) {
        this.strictVerification = strictVerification;
    }
}

