/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.client.ClusterableRequest;
import org.apache.openejb.client.ClusterableResponse;
import org.apache.openejb.client.EJBHomeProxyHandle;
import org.apache.openejb.client.EJBObjectProxyHandle;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Response;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.serializer.EJBDSerializer;
import org.apache.openejb.client.serializer.SerializationWrapper;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ejbd.BasicClusterableRequestHandler;
import org.apache.openejb.server.ejbd.CallContext;
import org.apache.openejb.server.ejbd.ClusterableRequestHandler;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.server.ejbd.RequestHandler;
import org.apache.openejb.server.ejbd.ServerSideResolver;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

class EjbRequestHandler
extends RequestHandler {
    public static final ServerSideResolver SERVER_SIDE_RESOLVER = new ServerSideResolver();
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE.createChild("ejb"), (String)"org.apache.openejb.server.util.resources");
    private final ClusterableRequestHandler clusterableRequestHandler;
    private final Map<String, AtomicBoolean> asynchronousInvocationCancelMap = new ConcurrentHashMap<String, AtomicBoolean>();

    protected EjbRequestHandler(EjbDaemon daemon) {
        super(daemon);
        this.clusterableRequestHandler = this.newClusterableRequestHandler();
    }

    protected BasicClusterableRequestHandler newClusterableRequestHandler() {
        return new BasicClusterableRequestHandler();
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public String getName() {
        return "EJB";
    }

    /*
     * Exception decompiling
     */
    @Override
    public Response processRequest(ObjectInputStream in, ProtocolMetaData metaData) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processResponse(Response response, ObjectOutputStream out, ProtocolMetaData metaData) throws Exception {
        if (EJBResponse.class.isInstance(response)) {
            EJBResponse res = (EJBResponse)response;
            try {
                res.setMetaData(metaData);
                res.writeExternal((ObjectOutput)out);
                return;
            }
            catch (Throwable t) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to write EjbResponse", t);
                    return;
                }
                if (!logger.isInfoEnabled()) return;
                logger.info("Failed to write EjbResponse - Debug for stacktrace: " + t);
                return;
            }
            finally {
                try {
                    ((SecurityService)SystemInstance.get().getComponent(SecurityService.class)).disassociate();
                }
                catch (Throwable t) {
                    logger.warning("Failed to disassociate security", t);
                }
                CallContext call = CallContext.getCallContext();
                if (null != call) {
                    call.reset();
                }
                EJBHomeProxyHandle.resolver.set(null);
                EJBObjectProxyHandle.resolver.set(null);
            }
        }
        logger.error("EjbRequestHandler cannot process an instance of: " + response.getClass().getName());
    }

    protected void updateServer(EJBRequest req, EJBResponse res) {
        CallContext callContext = CallContext.getCallContext();
        BeanContext beanContext = callContext.getBeanContext();
        this.clusterableRequestHandler.updateServer(beanContext, (ClusterableRequest)req, (ClusterableResponse)res);
    }

    protected void doFUTURE_CANCEL_METHOD(EJBRequest req, EJBResponse res) throws Exception {
        AtomicBoolean invocationCancelTag = this.asynchronousInvocationCancelMap.get(req.getBody().getRequestId());
        if (invocationCancelTag != null) {
            invocationCancelTag.set((Boolean)req.getBody().getMethodParameters()[0]);
            res.setResponse(req.getVersion(), 4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEjbObject_BUSINESS_METHOD(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        BeanContext beanContext = call.getBeanContext();
        boolean asynchronous = beanContext.isAsynchronous(req.getMethodInstance());
        try {
            Object result;
            if (asynchronous) {
                AtomicBoolean invocationCancelTag = new AtomicBoolean(false);
                ThreadContext.initAsynchronousCancelled((AtomicBoolean)invocationCancelTag);
                this.asynchronousInvocationCancelMap.put(req.getBody().getRequestId(), invocationCancelTag);
            }
            RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
            EJBDSerializer serializer = this.daemon.getSerializer();
            if (serializer != null) {
                req.setSerializer(serializer);
            }
            if ((result = c.invoke((Object)req.getDeploymentId(), InterfaceType.EJB_OBJECT, req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey())) != null && asynchronous) {
                result = ((Future)result).get();
            }
            Object realResult = serializer != null && result != null ? new SerializationWrapper(serializer.serialize(result), result.getClass().getName()) : result;
            res.setResponse(req.getVersion(), 4, realResult);
        }
        finally {
            if (asynchronous) {
                ThreadContext.removeAsynchronousCancelled();
                this.asynchronousInvocationCancelMap.remove(req.getBody().getRequestId());
            }
        }
    }

    protected void doEjbHome_METHOD(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), InterfaceType.EJB_HOME, req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        res.setResponse(req.getVersion(), 4, result);
    }

    protected void doEjbHome_CREATE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), InterfaceType.EJB_HOME, req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        if (result instanceof ProxyInfo) {
            ProxyInfo info = (ProxyInfo)result;
            res.setResponse(req.getVersion(), 4, info.getPrimaryKey());
        } else {
            result = new RemoteException("The bean is not EJB compliant.  The bean should be created or and exception should be thrown.");
            logger.error(req + "The bean is not EJB compliant.  The bean should be created or and exception should be thrown.");
            res.setResponse(req.getVersion(), 10, (Object)new ThrowableArtifact((Throwable)result));
        }
    }

    protected void doEjbHome_FIND(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        Object result = c.invoke((Object)req.getDeploymentId(), InterfaceType.EJB_HOME, req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        if (result instanceof Collection) {
            Object[] primaryKeys = ((Collection)result).toArray();
            for (int i = 0; i < primaryKeys.length; ++i) {
                ProxyInfo proxyInfo = (ProxyInfo)primaryKeys[i];
                primaryKeys[i] = proxyInfo == null ? null : proxyInfo.getPrimaryKey();
            }
            res.setResponse(req.getVersion(), 7, (Object)primaryKeys);
        } else if (result instanceof Enumeration) {
            Enumeration resultAsEnum = (Enumeration)result;
            ArrayList<Object> listOfPKs = new ArrayList<Object>();
            while (resultAsEnum.hasMoreElements()) {
                ProxyInfo proxyInfo = (ProxyInfo)resultAsEnum.nextElement();
                if (proxyInfo == null) {
                    listOfPKs.add(null);
                    continue;
                }
                listOfPKs.add(proxyInfo.getPrimaryKey());
            }
            res.setResponse(req.getVersion(), 20, (Object)listOfPKs.toArray(new Object[listOfPKs.size()]));
        } else if (result instanceof ProxyInfo) {
            ProxyInfo proxyInfo = (ProxyInfo)result;
            result = proxyInfo.getPrimaryKey();
            res.setResponse(req.getVersion(), 6, result);
        } else if (result == null) {
            res.setResponse(req.getVersion(), 6, null);
        } else {
            String message = "The bean is not EJB compliant. The finder method [" + req.getMethodInstance().getName() + "] is declared " + "to return neither Collection nor the Remote Interface, " + "but [" + result.getClass().getName() + "]";
            result = new RemoteException(message);
            logger.error(req + " " + message);
            res.setResponse(req.getVersion(), 10, result);
        }
    }

    protected void doEjbObject_GET_EJB_HOME(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_GET_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_GET_PRIMARY_KEY(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_IS_IDENTICAL(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbObject_REMOVE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        c.invoke((Object)req.getDeploymentId(), InterfaceType.EJB_OBJECT, req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        res.setResponse(req.getVersion(), 4, null);
    }

    protected void doEjbHome_GET_EJB_META_DATA(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbHome_GET_HOME_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        this.checkMethodAuthorization(req, res);
    }

    protected void doEjbHome_REMOVE_BY_HANDLE(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        c.invoke((Object)req.getDeploymentId(), InterfaceType.EJB_HOME, req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        res.setResponse(req.getVersion(), 4, null);
    }

    protected void doEjbHome_REMOVE_BY_PKEY(EJBRequest req, EJBResponse res) throws Exception {
        CallContext call = CallContext.getCallContext();
        RpcContainer c = (RpcContainer)call.getBeanContext().getContainer();
        c.invoke((Object)req.getDeploymentId(), InterfaceType.EJB_HOME, req.getInterfaceClass(), req.getMethodInstance(), req.getMethodParameters(), req.getPrimaryKey());
        res.setResponse(req.getVersion(), 4, null);
    }

    protected void checkMethodAuthorization(EJBRequest req, EJBResponse res) throws Exception {
        res.setResponse(req.getVersion(), 4, null);
    }

    private EJBResponse setResponseError(EJBResponse res, byte version, Throwable error, String message) {
        if (logger.isInfoEnabled()) {
            logger.info(message + " - Enable DEBUG for stacktrace: " + error);
        } else if (logger.isDebugEnabled()) {
            logger.debug(message, error);
        }
        RemoteException re = new RemoteException(message, error);
        res.setResponse(version, 11, (Object)new ThrowableArtifact((Throwable)re));
        return res;
    }
}

