/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.FilterListener;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.ServletListener;
import org.apache.webbeans.container.InjectableBeanManager;

public final class HttpUtil {
    private static final String WILDCARD = SystemInstance.get().getProperty("openejb.http.wildcard", ".*");

    private HttpUtil() {
    }

    public static String selectSingleAddress(List<String> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            return null;
        }
        for (String address : addresses) {
            if (!address.startsWith("http:")) continue;
            return address;
        }
        for (String address : addresses) {
            if (!address.startsWith("https:")) continue;
            return address;
        }
        return addresses.iterator().next();
    }

    public static void addDefaultsIfAvailable(WebContext wc) {
        try {
            Class<?> servlet = wc.getClassLoader().loadClass("org.apache.jasper.servlet.JspServlet");
            ((ServletContext)SystemInstance.get().getComponent(ServletContext.class)).setAttribute("org.apache.tomcat.InstanceManager", wc.getClassLoader().loadClass("org.apache.tomee.catalina.JavaeeInstanceManager").getConstructor(WebContext.class).newInstance(wc));
            HttpUtil.addServlet(servlet.getName(), wc, "*.jsp");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addServlet(final String classname, WebContext wc, String mapping) {
        ServletListener listener;
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        if (registry == null || mapping == null) {
            return false;
        }
        try {
            ServletContext servletContext = wc.getServletContext();
            if (servletContext == null) {
                servletContext = (ServletContext)SystemInstance.get().getComponent(ServletContext.class);
            }
            if ("javax.faces.webapp.FacesServlet".equals(classname)) {
                try {
                    Class<?> mfListenerClass = wc.getClassLoader().loadClass("org.apache.myfaces.webapp.StartupServletContextListener");
                    ServletContextListener servletContextListener = (ServletContextListener)ServletContextListener.class.cast(mfListenerClass.newInstance());
                    servletContext.setAttribute("javax.enterprise.inject.spi.BeanManager", (Object)new InjectableBeanManager(wc.getWebBeansContext().getBeanManagerImpl()));
                    Thread thread = Thread.currentThread();
                    ClassLoader old = HttpUtil.setClassLoader(wc, thread);
                    try {
                        servletContextListener.contextInitialized(new ServletContextEvent(servletContext));
                    }
                    finally {
                        thread.setContextClassLoader(old);
                    }
                    servletContext.removeAttribute("javax.enterprise.inject.spi.BeanManager");
                }
                catch (Exception mfListenerClass) {
                    // empty catch block
                }
            }
            Thread thread = Thread.currentThread();
            ClassLoader old = HttpUtil.setClassLoader(wc, thread);
            try {
                listener = new ServletListener((Servlet)wc.newInstance(wc.getClassLoader().loadClass(classname)), wc.getContextRoot());
                final ServletContext sc = servletContext;
                listener.getDelegate().init(new ServletConfig(){

                    public String getServletName() {
                        return classname;
                    }

                    public ServletContext getServletContext() {
                        return sc;
                    }

                    public String getInitParameter(String s) {
                        return sc.getInitParameter(s);
                    }

                    public Enumeration<String> getInitParameterNames() {
                        Enumeration parameterNames = sc.getInitParameterNames();
                        return parameterNames == null ? Collections.emptyEnumeration() : parameterNames;
                    }
                });
            }
            finally {
                thread.setContextClassLoader(old);
            }
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
        registry.addHttpListener(listener, HttpUtil.pattern(wc.getContextRoot(), "/".equals(mapping) ? "/*" : mapping));
        return true;
    }

    private static void setJspFactory() {
        try {
            ClassLoader classLoader = ParentClassLoaderFinder.Helper.get();
            Class<?> jspFactory = classLoader.loadClass("org.apache.jasper.runtime.JspFactoryImpl");
            Class<?> jspFactoryApi = classLoader.loadClass("javax.servlet.jsp.JspFactory");
            jspFactoryApi.getMethod("setDefaultFactory", jspFactoryApi).invoke(null, jspFactory.newInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static ClassLoader setClassLoader(WebContext wc, Thread thread) {
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(wc.getClassLoader() == null ? wc.getAppContext().getClassLoader() : wc.getClassLoader());
        return old;
    }

    public static void removeServlet(String mapping, WebContext wc) {
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        if (registry == null || mapping == null) {
            return;
        }
        Servlet servlet = ((ServletListener)registry.removeHttpListener(HttpUtil.pattern(wc.getContextRoot(), mapping))).getDelegate();
        servlet.destroy();
        wc.destroy((Object)servlet);
        if (servlet.getClass().equals("org.apache.jasper.servlet.JspServlet")) {
            ((ServletContext)SystemInstance.get().getComponent(ServletContext.class)).removeAttribute("org.apache.tomcat.InstanceManager");
        }
    }

    public static boolean addFilter(String classname, WebContext wc, String mapping, FilterConfig config) {
        FilterListener listener;
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        if (registry == null || mapping == null) {
            return false;
        }
        try {
            listener = new FilterListener((Filter)wc.newInstance(wc.getClassLoader().loadClass(classname)), wc.getContextRoot());
            listener.getDelegate().init(config);
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
        registry.addHttpFilter(listener, HttpUtil.pattern(wc.getContextRoot(), mapping));
        return true;
    }

    public static void removeFilter(String mapping, WebContext wc) {
        HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
        if (registry == null || mapping == null) {
            return;
        }
        Collection<HttpListener> filters = registry.removeHttpFilter(HttpUtil.pattern(wc.getContextRoot(), mapping));
        for (HttpListener listener : filters) {
            Filter filter = ((FilterListener)listener).getDelegate();
            filter.destroy();
            wc.destroy((Object)filter);
        }
        filters.clear();
    }

    private static String pattern(String contextRoot, String mapping) {
        String path = "";
        if (contextRoot != null) {
            path = contextRoot;
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!mapping.startsWith("/") && !path.endsWith("/")) {
            path = path + '/';
        }
        if ((path = path + (mapping.startsWith("*.") ? WILDCARD + "\\" + mapping.substring(1) : mapping)).endsWith("*")) {
            path = path.substring(0, path.length()) + WILDCARD;
        }
        return path;
    }

    static {
        HttpUtil.setJspFactory();
    }
}

