/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;

public class WebBeansFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        WebBeansContext ctx = null;
        filterChain.doFilter((ServletRequest)(servletRequest.isAsyncSupported() && (ctx = WebBeansContext.currentInstance()) != null ? new CdiRequest((HttpServletRequest)HttpServletRequest.class.cast(servletRequest), ctx) : servletRequest), servletResponse);
    }

    public void destroy() {
    }

    public static class AsynContextWrapper
    implements AsyncContext {
        private final AsyncContext delegate;
        private final CdiAppContextsService service;
        private final ServletRequest request;
        private volatile ServletRequestEvent event;

        public AsynContextWrapper(AsyncContext asyncContext, ServletRequest request, WebBeansContext webBeansContext) {
            this.delegate = asyncContext;
            this.service = (CdiAppContextsService)CdiAppContextsService.class.cast(webBeansContext.getService(ContextsService.class));
            this.event = null;
            this.request = request;
        }

        private boolean startRequestScope() {
            if (this.service.getRequestContext(false) == null) {
                this.service.startContext(RequestScoped.class, (Object)this.getEvent());
                return true;
            }
            return false;
        }

        private void stopRequestScope() {
            this.service.endContext(RequestScoped.class, (Object)this.getEvent());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServletRequestEvent getEvent() {
            ServletRequest request = this.getRequest();
            if (this.event == null || this.event.getServletRequest() != request) {
                AsynContextWrapper asynContextWrapper = this;
                synchronized (asynContextWrapper) {
                    if (this.event == null || this.event.getServletRequest() != request) {
                        this.event = new ServletRequestEvent(request.getServletContext(), request);
                    }
                }
            }
            return this.event;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.delegate.getResponse();
        }

        public boolean hasOriginalRequestAndResponse() {
            return this.delegate.hasOriginalRequestAndResponse();
        }

        public void dispatch() {
            this.delegate.dispatch();
        }

        public void dispatch(String s) {
            this.delegate.dispatch(s);
        }

        public void dispatch(ServletContext servletContext, String s) {
            this.delegate.dispatch(servletContext, s);
        }

        public void complete() {
            boolean created = this.startRequestScope();
            try {
                this.delegate.complete();
            }
            finally {
                if (created) {
                    this.stopRequestScope();
                }
            }
        }

        public void start(final Runnable runnable) {
            this.delegate.start(new Runnable(){

                @Override
                public void run() {
                    AsynContextWrapper.this.startRequestScope();
                    try {
                        runnable.run();
                    }
                    finally {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            });
        }

        public void addListener(AsyncListener asyncListener) {
            this.delegate.addListener(this.wrapListener(asyncListener));
        }

        private AsyncListener wrapListener(AsyncListener asyncListener) {
            return new ScopeAwareListener(asyncListener);
        }

        public void addListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.delegate.addListener(this.wrapListener(asyncListener), servletRequest, servletResponse);
        }

        public <T extends AsyncListener> T createListener(Class<T> aClass) throws ServletException {
            return (T)this.delegate.createListener(aClass);
        }

        public void setTimeout(long l) {
            this.delegate.setTimeout(l);
        }

        public long getTimeout() {
            return this.delegate.getTimeout();
        }

        private class ScopeAwareListener
        implements AsyncListener {
            private final AsyncListener delegate;

            public ScopeAwareListener(AsyncListener asyncListener) {
                this.delegate = asyncListener;
            }

            public void onComplete(AsyncEvent event) throws IOException {
                boolean created = AsynContextWrapper.this.startRequestScope();
                try {
                    this.delegate.onComplete(event);
                }
                finally {
                    if (created) {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                boolean created = AsynContextWrapper.this.startRequestScope();
                try {
                    this.delegate.onTimeout(event);
                }
                finally {
                    if (created) {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            }

            public void onError(AsyncEvent event) throws IOException {
                boolean created = AsynContextWrapper.this.startRequestScope();
                try {
                    this.delegate.onError(event);
                }
                finally {
                    if (created) {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                boolean created = AsynContextWrapper.this.startRequestScope();
                try {
                    this.delegate.onStartAsync(event);
                }
                finally {
                    if (created) {
                        AsynContextWrapper.this.stopRequestScope();
                    }
                }
            }
        }
    }

    public static class CdiRequest
    extends HttpServletRequestWrapper {
        private final WebBeansContext webBeansContext;

        public CdiRequest(HttpServletRequest cast, WebBeansContext webBeansContext) {
            super(cast);
            this.webBeansContext = webBeansContext;
        }

        public AsyncContext startAsync() throws IllegalStateException {
            return new AsynContextWrapper(super.startAsync(), this.getRequest(), this.webBeansContext);
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            return new AsynContextWrapper(super.startAsync(servletRequest, servletResponse), servletRequest, this.webBeansContext);
        }
    }
}

