/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openejb.loader.IO;
import org.apache.openejb.server.cli.command.Command;
import org.apache.openejb.server.cli.command.PathCommand;

@Command(name="part", usage="part <first line>-<last line> <path>", description="print the specified line range of a file (in tomee directories only)")
public class PartCommand
extends PathCommand {
    private static final Pattern PATTERN = Pattern.compile("([0-9]*)-([0-9]*) (.*)");

    @Override
    public void execute(String cmd) {
        File file;
        int secondLine;
        int firstLine;
        Matcher matcher = PATTERN.matcher(cmd);
        if (!matcher.matches()) {
            this.streamManager.writeErr("you have to specify a numbe of line, please see help for more information");
            return;
        }
        try {
            firstLine = this.getInt(matcher.group(1));
            secondLine = this.getInt(matcher.group(2));
        }
        catch (NumberFormatException nfe) {
            this.streamManager.writeErr("line number was not parsable");
            return;
        }
        String path = matcher.group(3);
        try {
            file = this.resolve(path);
        }
        catch (IllegalArgumentException iae) {
            this.streamManager.writeErr(iae.getMessage());
            return;
        }
        if (file.isDirectory() && file.exists()) {
            this.streamManager.writeOut("file " + file.getPath() + " is a directory, please specify a regular file");
        } else if (file.exists()) {
            try {
                this.part(file, firstLine, secondLine);
            }
            catch (IOException e) {
                this.streamManager.writeErr(e);
            }
        } else {
            this.streamManager.writeOut("file " + file.getPath() + " doesn't exist");
        }
    }

    private int getInt(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (NumberFormatException nfe) {
            this.streamManager.writeErr("line number should be an integer");
            throw nfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void part(File file, int firstLine, int secondLine) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        int totalLineNumber = 0;
        try {
            while (br.readLine() != null) {
                ++totalLineNumber;
            }
        }
        finally {
            IO.close((Closeable)br);
        }
        br = new BufferedReader(new FileReader(file));
        try {
            String line;
            int firstLineToPrint = Math.max(1, firstLine);
            int lastLine = Math.min(totalLineNumber, secondLine);
            totalLineNumber = 0;
            while ((line = br.readLine()) != null) {
                if (++totalLineNumber >= firstLineToPrint && totalLineNumber <= lastLine) {
                    this.streamManager.writeOut(String.format("%3d. %s", totalLineNumber, line));
                }
                if (totalLineNumber <= lastLine) continue;
                break;
            }
        }
        finally {
            IO.close((Closeable)br);
        }
    }
}

