/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.testing.TestInstance;
import org.mockito.Mock;

public class MockRegistry {
    private static boolean initialized = false;
    private static final Map<Class<?>, Object> mockInstancesByType = new HashMap();
    private static final Map<String, Object> mockInstancesByName = new HashMap<String, Object>();

    public static void reset() {
        initialized = false;
        mockInstancesByType.clear();
        mockInstancesByName.clear();
    }

    public static Map<Class<?>, Object> mocksByType() {
        MockRegistry.ensureInit();
        return mockInstancesByType;
    }

    public static Map<String, Object> mocksByName() {
        MockRegistry.ensureInit();
        return mockInstancesByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInit() {
        if (initialized) return;
        Class<MockRegistry> clazz = MockRegistry.class;
        synchronized (MockRegistry.class) {
            if (initialized) return;
            TestInstance instance = (TestInstance)SystemInstance.get().getComponent(TestInstance.class);
            if (instance != null) {
                Class current = instance.getTestClass();
                while (!current.equals(Object.class)) {
                    block9: for (Field f : current.getDeclaredFields()) {
                        for (Annotation annotation : f.getAnnotations()) {
                            if (!annotation.annotationType().getName().startsWith("org.mockito.")) continue;
                            boolean acc = f.isAccessible();
                            try {
                                f.setAccessible(true);
                                Object mockInstance = f.get(instance.getInstance());
                                if (Mock.class.equals(annotation.annotationType())) {
                                    Mock mock = (Mock)annotation;
                                    if (!"".equals(mock.name())) {
                                        mockInstancesByName.put(mock.name(), mockInstance);
                                        continue block9;
                                    }
                                    mockInstancesByType.put(f.getType(), mockInstance);
                                    continue block9;
                                }
                                mockInstancesByType.put(f.getType(), mockInstance);
                                continue block9;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                continue block9;
                            }
                            finally {
                                f.setAccessible(acc);
                            }
                        }
                    }
                    current = current.getSuperclass();
                }
            }
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

