/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import java.util.HashMap;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.mdb.BasicMdbObject;
import org.apache.openejb.test.mdb.MdbInvoker;
import org.apache.openejb.test.object.OperationsPolicy;

public class BasicMdbBean
implements BasicMdbObject,
MessageDrivenBean,
MessageListener {
    private MessageDrivenContext mdbContext = null;
    private static final HashMap<String, OperationsPolicy> allowedOperationsTable = new HashMap();
    protected MdbInvoker mdbInvoker;

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
        this.mdbContext = ctx;
        this.testAllowedOperations("setMessageDrivenContext");
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)new InitialContext().lookup("java:comp/env/jms");
            this.mdbInvoker = new MdbInvoker(connectionFactory, this);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void onMessage(Message message) {
        try {
            try {
                message.acknowledge();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            this.mdbInvoker.onMessage(message);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    @Override
    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Testing ability to throw Application Exceptions");
    }

    @Override
    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Testing ability to throw System Exceptions");
    }

    @Override
    public Properties getPermissionsReport() {
        return null;
    }

    @Override
    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return allowedOperationsTable.get(methodName);
    }

    public void ejbCreate() throws CreateException {
        this.testAllowedOperations("ejbCreate");
    }

    public void ejbRemove() throws EJBException {
        if (null != this.mdbInvoker) {
            this.mdbInvoker.destroy();
        }
        this.testAllowedOperations("ejbRemove");
    }

    protected void testAllowedOperations(String methodName) {
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.mdbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        try {
            this.mdbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        try {
            this.mdbContext.isCallerInRole("TheMan");
            policy.allow(2);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        try {
            this.mdbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        try {
            this.mdbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        try {
            InitialContext jndiContext = new InitialContext();
            String actual = (String)jndiContext.lookup("java:comp/env/stateless/references/JNDI_access_to_java_comp_env");
            policy.allow(8);
        }
        catch (IllegalStateException | NamingException ignored) {
            // empty catch block
        }
        try {
            this.mdbContext.lookup("stateless/references/JNDI_access_to_java_comp_env");
            policy.allow(11);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        allowedOperationsTable.put(methodName, policy);
    }
}

