/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.object.OperationsPolicy;

public class AllowedOperationsCmpBean
implements EntityBean {
    private static int nextId;
    public Integer primaryKey;
    public String firstName;
    public String lastName;
    public int number;
    public EntityContext ejbContext;
    public static Map<String, OperationsPolicy> allowedOperationsTable;

    public int ejbHomeSum(int x, int y) {
        this.testAllowedOperations("ejbHome");
        return x + y;
    }

    public void ejbHomeVoidSelect() {
    }

    public Integer ejbCreateObject(String name) throws CreateException {
        this.primaryKey = nextId++;
        this.testAllowedOperations("ejbCreate");
        StringTokenizer st = new StringTokenizer(name, " ");
        this.firstName = st.nextToken();
        this.lastName = st.nextToken();
        return new Integer(this.primaryKey);
    }

    public void ejbPostCreateObject(String name) throws CreateException {
        this.testAllowedOperations("ejbPostCreate");
    }

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        ++this.number;
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Don't Panic");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Panic");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return allowedOperationsTable.get(methodName);
    }

    public void ejbLoad() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbLoad");
    }

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
        this.testAllowedOperations("setEntityContext");
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
        this.testAllowedOperations("unsetEntityContext");
    }

    public void ejbStore() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbStore");
    }

    public void ejbRemove() throws RemoveException, EJBException, RemoteException {
        this.testAllowedOperations("ejbRemove");
    }

    public void ejbActivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("TheMan");
            policy.allow(2);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getPrimaryKey();
            policy.allow(7);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            InitialContext jndiContext = new InitialContext();
            jndiContext.lookup("java:comp/env/stateless/references/JNDI_access_to_java_comp_env");
            policy.allow(8);
        }
        catch (IllegalStateException | NamingException exception) {
            // empty catch block
        }
        allowedOperationsTable.put(methodName, policy);
    }

    static {
        allowedOperationsTable = new TreeMap<String, OperationsPolicy>();
    }
}

