/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.bmp;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.openejb.test.object.OperationsPolicy;

public class BasicBmp2DataSourcesBean
implements EntityBean {
    public static int primaryKey = 1;
    public String firstName;
    public String lastName;
    public EntityContext ejbContext;
    public Hashtable allowedOperationsTable = new Hashtable();

    public int ejbHomeSum(int x, int y) {
        this.testAllowedOperations("ejbHome");
        return x + y;
    }

    public Collection ejbFindEmptyCollection() throws FinderException, RemoteException {
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer ejbFindByPrimaryKey(Integer primaryKey) throws FinderException {
        boolean found = false;
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            try (Connection con = ds.getConnection();
                 PreparedStatement stmt = con.prepareStatement("select * from entity where id = ?");){
                stmt.setInt(1, primaryKey);
                found = stmt.executeQuery().next();
            }
        }
        catch (Exception e) {
            throw new FinderException("FindByPrimaryKey failed");
        }
        if (found) {
            return primaryKey;
        }
        throw new ObjectNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer ejbCreate(String name) throws CreateException {
        try {
            PreparedStatement stmt;
            StringTokenizer st = new StringTokenizer(name, " ");
            this.firstName = st.nextToken();
            this.lastName = st.nextToken();
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            try (Connection con = ds.getConnection();){
                stmt = con.prepareStatement("insert into entity (id, first_name, last_name) values (?,?,?)");
                try {
                    stmt.setInt(1, primaryKey++);
                    stmt.setString(2, this.firstName);
                    stmt.setString(3, this.lastName);
                    stmt.executeUpdate();
                }
                finally {
                    stmt.close();
                }
                stmt = con.prepareStatement("select id from entity where first_name = ? AND last_name = ?");
                try {
                    stmt.setString(1, this.firstName);
                    stmt.setString(2, this.lastName);
                    ResultSet set = stmt.executeQuery();
                    while (set.next()) {
                        primaryKey = set.getInt("id");
                    }
                }
                finally {
                    stmt.close();
                }
            }
            ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabaseBackup");
            con = ds.getConnection();
            try {
                stmt = con.prepareStatement("insert into entityBackup (id, first_name, last_name) values (?,?,?)");
                try {
                    stmt.setInt(1, primaryKey);
                    stmt.setString(2, this.firstName);
                    stmt.setString(3, this.lastName);
                    stmt.executeUpdate();
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                con.close();
            }
            return new Integer(primaryKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CreateException("can't create");
        }
    }

    public void ejbPostCreate(String name) throws CreateException {
    }

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return (OperationsPolicy)this.allowedOperationsTable.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbLoad() throws EJBException, RemoteException {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            try (Connection con = ds.getConnection();
                 PreparedStatement stmt = con.prepareStatement("select * from entity where id = ?");){
                Integer primaryKey = (Integer)this.ejbContext.getPrimaryKey();
                stmt.setInt(1, primaryKey);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    this.lastName = rs.getString("last_name");
                    this.firstName = rs.getString("first_name");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.ejbContext = ctx;
        this.testAllowedOperations("setEntityContext");
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
        this.testAllowedOperations("unsetEntityContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbStore() throws EJBException, RemoteException {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            try (Connection con = ds.getConnection();
                 PreparedStatement stmt = con.prepareStatement("update entity set first_name = ?, last_name = ? where EmployeeID = ?");){
                stmt.setString(1, this.firstName);
                stmt.setString(2, this.lastName);
                stmt.setInt(3, primaryKey);
                stmt.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbRemove() throws RemoveException, EJBException, RemoteException {
        try {
            InitialContext jndiContext = new InitialContext();
            DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/basic/entityDatabase");
            try (Connection con = ds.getConnection();
                 PreparedStatement stmt = con.prepareStatement("delete from entity where id = ?");){
                Integer primaryKey = (Integer)this.ejbContext.getPrimaryKey();
                stmt.setInt(1, primaryKey);
                stmt.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("TheMan");
            policy.allow(2);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.setRollbackOnly();
            policy.allow(4);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.ejbContext.getPrimaryKey();
            policy.allow(7);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.allowedOperationsTable.put(methodName, policy);
    }
}

