/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.derbynet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.LoggingPrintWriter;

public class DerbyNetworkService
implements ServerService,
SelfManaging {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, DerbyNetworkService.class);
    private NetworkServerControl serverControl;
    private int port = 1527;
    private boolean disabled;
    private InetAddress host;
    private boolean verbose = false;

    public String getIP() {
        return this.host.getHostAddress();
    }

    public String getName() {
        return "derbynet";
    }

    public int getPort() {
        return this.port;
    }

    public void init(Properties properties) throws Exception {
        Options options = new Options(properties);
        this.port = options.get("port", 1527);
        this.disabled = options.get("disabled", false);
        this.verbose = options.get("verbose", false);
        this.host = InetAddress.getByName("0.0.0.0");
        System.setProperty("derby.system.home", options.get("derby.system.home", SystemInstance.get().getBase().getDirectory().getAbsolutePath()));
    }

    public void service(InputStream inputStream, OutputStream outputStream) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public void start() throws ServiceException {
        if (this.disabled) {
            return;
        }
        try {
            this.serverControl = new NetworkServerControl(this.host, this.port);
            this.serverControl.start((PrintWriter)new LoggingPrintWriter("Derby"));
            if (this.verbose) {
                LOGGER.info("Starting openejb-derbynet with derby " + this.serverControl.getRuntimeInfo() + " " + this.serverControl.getSysinfo());
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void stop() throws ServiceException {
        if (this.serverControl == null) {
            return;
        }
        try {
            this.serverControl.shutdown();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            this.serverControl = null;
        }
    }
}

