/*
 * Decompiled with CFR 0.152.
 */
package javax.batch.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.batch.operations.JobOperator;
import org.apache.geronimo.osgi.locator.ProviderLocator;

public class BatchRuntime {
    public static JobOperator getJobOperator() {
        if (System.getSecurityManager() == null) {
            return BatchRuntime.findJobOperator();
        }
        return AccessController.doPrivileged(new PrivilegedAction<JobOperator>(){

            @Override
            public JobOperator run() {
                return BatchRuntime.findJobOperator();
            }
        });
    }

    private static JobOperator findJobOperator() {
        Iterator<JobOperator> iterator = BatchRuntime.operators();
        while (iterator.hasNext()) {
            JobOperator provider = iterator.next();
            if (provider == null) continue;
            return provider;
        }
        return null;
    }

    private static Iterator<JobOperator> operators() {
        try {
            return ((List)ProviderLocator.getService(JobOperator.class.getName(), JobOperator.class, Thread.currentThread().getContextClassLoader())).iterator();
        }
        catch (Throwable th) {
            return ServiceLoader.load(JobOperator.class).iterator();
        }
    }
}

