/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.arquillian.webapp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.arquillian.common.ArquillianFilterRunner;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.Setup;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.arquillian.common.Zips;
import org.apache.openejb.config.RemoteServer;
import org.apache.tomee.arquillian.webapp.TomEEWebappConfiguration;
import org.apache.tomee.installer.Installer;
import org.apache.tomee.installer.Paths;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;

public class TomEEWebappContainer
extends TomEEContainer<TomEEWebappConfiguration> {
    private static final Logger logger = Logger.getLogger(TomEEWebappContainer.class.getName());
    private RemoteServer container;
    private boolean shutdown;
    private File openejbHome;
    private boolean wereOpenejbHomeSet = true;

    protected String providerUrl() {
        return String.format(((TomEEWebappConfiguration)this.configuration).getProviderUrlPattern(), super.providerUrl());
    }

    public void start() throws LifecycleException {
        int httpPort = ((TomEEWebappConfiguration)this.configuration).getHttpPort();
        if (Setup.isRunning((String)((TomEEWebappConfiguration)this.configuration).getHost(), (int)httpPort)) {
            logger.info(String.format("Tomcat found running on port %s", httpPort));
            return;
        }
        this.shutdown = true;
        String s = File.separator;
        try {
            File workingDirectory = new File(((TomEEWebappConfiguration)this.configuration).getDir());
            if (workingDirectory.exists()) {
                Files.assertDir((File)workingDirectory);
            } else {
                Files.mkdir((File)workingDirectory);
                Files.deleteOnExit((File)workingDirectory);
            }
            Files.readable((File)workingDirectory);
            Files.writable((File)workingDirectory);
            this.openejbHome = Setup.findHome((File)workingDirectory);
            Installer installer = null;
            if (this.openejbHome == null) {
                this.downloadTomcat(workingDirectory, ((TomEEWebappConfiguration)this.configuration).getTomcatVersion(), ((TomEEWebappConfiguration)this.configuration).getDir());
                this.openejbHome = Setup.findHome((File)workingDirectory);
                Files.deleteOnExit((File)this.openejbHome);
                File webapp = new File(this.openejbHome, "webapps" + s + "tomee");
                Files.mkdir((File)webapp);
                this.downloadOpenEJBWebapp(webapp, ((TomEEWebappConfiguration)this.configuration).getDir());
                System.setProperty("catalina.home", this.openejbHome.getAbsolutePath());
                System.setProperty("catalina.base", this.openejbHome.getAbsolutePath());
                System.setProperty("openejb.deploymentId.format", System.getProperty("openejb.deploymentId.format", "{appId}/{ejbJarId}/{ejbName}"));
                Paths paths = new Paths(webapp);
                installer = new Installer(paths, true);
                if (!((TomEEWebappConfiguration)this.configuration).isUseInstallerServlet()) {
                    installer.installAll();
                }
                this.wereOpenejbHomeSet = false;
            }
            Files.assertDir((File)this.openejbHome);
            Files.readable((File)this.openejbHome);
            Files.writable((File)this.openejbHome);
            Setup.configureServerXml((File)this.openejbHome, (TomEEConfiguration)this.configuration);
            Setup.configureSystemProperties((File)this.openejbHome, (TomEEConfiguration)this.configuration);
            Setup.exportProperties((File)this.openejbHome, (TomEEConfiguration)this.configuration, (boolean)true);
            URL logging = Thread.currentThread().getContextClassLoader().getResource("default.remote.logging.properties");
            if (logging != null) {
                TomEEWebappContainer.write(logging, new File(this.openejbHome, "conf" + s + "logging.properties"));
            }
            if (((TomEEWebappConfiguration)this.configuration).isRemoveUnusedWebapps()) {
                Setup.removeUselessWebapps((File)this.openejbHome, (String[])new String[]{"tomee"});
            }
            if (logger.isLoggable(Level.FINE)) {
                TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
                for (Map.Entry entry : map.entrySet()) {
                    System.out.printf("%s = %s\n", entry.getKey(), entry.getValue());
                }
            }
            Setup.installArquillianBeanDiscoverer((File)this.openejbHome);
            if (!this.wereOpenejbHomeSet && ((TomEEWebappConfiguration)this.configuration).isUseInstallerServlet()) {
                String baseUrl = "http://" + ((TomEEWebappConfiguration)this.configuration).getHost() + ":" + httpPort + "/tomee/installer";
                assert (installer != null);
                installer.addTomEEAdminConfInTomcatUsers(true);
                RemoteServer tmpContainer = new RemoteServer();
                tmpContainer.setPortStartup(httpPort);
                try {
                    tmpContainer.start();
                }
                catch (Exception e) {
                    tmpContainer.destroy();
                    throw e;
                }
                URL url = new URL(baseUrl);
                logger.info("Calling TomEE Installer Servlet on " + url);
                for (int i = 0; i < Integer.getInteger("tomee.webapp.container.client.retries", 3); ++i) {
                    URLConnection uc = url.openConnection();
                    String authorizationString = "Basic dG9tZWU6dG9tZWU=";
                    int timeout = Integer.getInteger("tomee.webapp.container.client.timeout", 60000);
                    uc.setConnectTimeout(timeout);
                    uc.setReadTimeout(timeout);
                    uc.setRequestProperty("Authorization", "Basic dG9tZWU6dG9tZWU=");
                    try {
                        InputStream is = uc.getInputStream();
                        org.apache.openejb.loader.IO.slurp((InputStream)is);
                        is.close();
                        break;
                    }
                    catch (Exception e) {
                        logger.warning(e.getMessage());
                        Thread.sleep(1000L);
                        continue;
                    }
                }
                tmpContainer.stop();
                tmpContainer.getServer().waitFor();
            }
            this.container = new RemoteServer();
            this.container.setPortStartup(httpPort);
            this.container.start(Arrays.asList("-Dopenejb.system.apps=true", "-Dtomee.remote.support=true", "-Dorg.apache.openejb.servlet.filters=" + ArquillianFilterRunner.class.getName() + "=" + "/ArquillianServletRunner"), "start", true);
            this.container.killOnExit();
        }
        catch (Exception e) {
            if (null != this.container) {
                this.container.destroy();
            }
            throw new LifecycleException("Unable to start remote container on port: " + httpPort, (Throwable)e);
        }
    }

    private static void write(URL resource, File file) throws IOException {
        if (file.exists()) {
            Files.delete((File)file);
        }
        try (InputStream is = org.apache.openejb.loader.IO.read((URL)resource);){
            IO.copy((InputStream)is, (File)file);
        }
    }

    protected void downloadOpenEJBWebapp(File targetDirectory, String defaultTempDir) throws LifecycleException {
        String artifactName = ((TomEEWebappConfiguration)this.configuration).getArtifactName();
        File zipFile = Setup.downloadFile((String)artifactName, null, (String)defaultTempDir);
        Zips.unzip((File)zipFile, (File)targetDirectory);
    }

    protected void downloadTomcat(File catalinaDirectory, String tomcatVersion, String defaultTempDir) throws LifecycleException {
        String source = null;
        try {
            int v = Integer.parseInt(tomcatVersion.substring(0, tomcatVersion.indexOf(46)));
            source = "http://archive.apache.org/dist/tomcat/tomcat-" + v + "/v" + v + "/bin/apache-tomcat-" + tomcatVersion + ".zip";
        }
        catch (Exception v) {
            // empty catch block
        }
        if (source == null) {
            throw new LifecycleException("Unable to find URL for Tomcat " + tomcatVersion);
        }
        File zipFile = Setup.downloadFile((String)("org.apache.tomcat:tomcat:" + tomcatVersion + ":zip"), source, (String)defaultTempDir);
        Zips.unzip((File)zipFile, (File)catalinaDirectory);
    }

    public void stop() throws LifecycleException {
        if (this.shutdown) {
            try {
                Setup.removeArquillianBeanDiscoverer((File)this.openejbHome);
                this.container.destroy();
            }
            finally {
                this.resetSerialization();
            }
        }
    }

    public Class<TomEEWebappConfiguration> getConfigurationClass() {
        return TomEEWebappConfiguration.class;
    }
}

