/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.Multiline;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class TomEEConfiguration
implements ContainerConfiguration {
    protected boolean exportConfAsSystemProperty;
    protected int httpsPort = 8443;
    protected int httpPort = 8080;
    protected int stopPort = 8005;
    protected String dir = System.getProperty("java.io.tmpdir") + "/arquillian-apache-tomee";
    protected String appWorkingDir = System.getProperty("java.io.tmpdir") + "/arquillian-tomee-app-working-dir";
    protected String host = "localhost";
    protected String stopHost = "localhost";
    protected String stopCommand = "SHUTDOWN";
    protected String serverXml;
    protected String portRange = "";
    protected String preloadClasses;
    protected boolean quickSession = true;
    protected boolean unsafeEjbd = true;
    protected boolean unpackWars = true;
    protected String properties = "";
    protected String webContextToUseWithEars;
    protected boolean keepServerXmlAsThis;
    protected boolean singleDumpByArchiveName;
    protected Collection<String> singleDeploymentByArchiveName = Collections.emptyList();

    public boolean isUnsafeEjbd() {
        return this.unsafeEjbd;
    }

    public void setUnsafeEjbd(boolean unsafeEjbd) {
        this.unsafeEjbd = unsafeEjbd;
    }

    public boolean isUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean unpackWars) {
        this.unpackWars = unpackWars;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getAppWorkingDir() {
        return this.appWorkingDir;
    }

    public void setAppWorkingDir(String appWorkingDir) {
        this.appWorkingDir = appWorkingDir;
    }

    public void validate() throws ConfigurationException {
    }

    public boolean getExportConfAsSystemProperty() {
        return this.exportConfAsSystemProperty;
    }

    public void setExportConfAsSystemProperty(boolean exportConfAsSystemProperty) {
        this.exportConfAsSystemProperty = exportConfAsSystemProperty;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getServerXml() {
        return this.serverXml;
    }

    public void setServerXml(String serverXml) {
        this.serverXml = serverXml;
    }

    public String getProperties() {
        return this.properties;
    }

    @Multiline
    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String systemProperties() {
        return this.properties.replaceAll("\n *", "\n");
    }

    public String getPortRange() {
        return this.portRange;
    }

    public void setPortRange(String portRange) {
        this.portRange = portRange;
    }

    public boolean isQuickSession() {
        return this.quickSession;
    }

    public void setQuickSession(boolean quickSession) {
        this.quickSession = quickSession;
    }

    public int[] portsAlreadySet() {
        ArrayList<Integer> value = new ArrayList<Integer>();
        if (this.stopPort > 0) {
            value.add(this.stopPort);
        }
        if (this.httpPort > 0) {
            value.add(this.httpPort);
        }
        if (this.httpsPort > 0) {
            value.add(this.httpsPort);
        }
        return this.toInts(value);
    }

    protected int[] toInts(List<Integer> values) {
        int[] array = new int[values.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = values.get(i);
        }
        return array;
    }

    public String getStopHost() {
        return this.stopHost;
    }

    public void setStopHost(String stopHost) {
        this.stopHost = stopHost;
    }

    public String getStopCommand() {
        return this.stopCommand + Character.toString('\u0000');
    }

    public void setStopCommand(String stopCommand) {
        this.stopCommand = stopCommand;
    }

    public String getPreloadClasses() {
        return this.preloadClasses;
    }

    public void setPreloadClasses(String preloadClasses) {
        this.preloadClasses = preloadClasses;
    }

    public String getWebContextToUseWithEars() {
        return this.webContextToUseWithEars;
    }

    public void setWebContextToUseWithEars(String webContextToUseWithEars) {
        this.webContextToUseWithEars = webContextToUseWithEars;
    }

    public boolean getKeepServerXmlAsThis() {
        return this.keepServerXmlAsThis;
    }

    public void setKeepServerXmlAsThis(boolean keepServerXmlAsThis) {
        this.keepServerXmlAsThis = keepServerXmlAsThis;
    }

    public boolean isSingleDumpByArchiveName() {
        return this.singleDumpByArchiveName;
    }

    public void setSingleDumpByArchiveName(boolean singleDumpByArchiveName) {
        this.singleDumpByArchiveName = singleDumpByArchiveName;
    }

    public boolean isSingleDeploymentByArchiveName(String name) {
        return this.singleDeploymentByArchiveName.contains(name) || this.singleDeploymentByArchiveName.contains("*") || this.singleDeploymentByArchiveName.contains("true");
    }

    public void setSingleDeploymentByArchiveName(String singleDeploymentByArchiveName) {
        this.singleDeploymentByArchiveName = singleDeploymentByArchiveName == null || singleDeploymentByArchiveName.trim().isEmpty() ? Collections.emptyList() : new HashSet<String>(Arrays.asList(singleDeploymentByArchiveName.split(" *, *")));
        this.singleDumpByArchiveName = true;
    }
}

