/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.arquillian.common.enrichment.OpenEJBEnricher;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.TestEnricher;

public class TomEEInjectionEnricher
implements TestEnricher {
    @Inject
    private Instance<TestClass> testClass;
    @Inject
    private Instance<Deployment> deployment;

    public void enrich(Object o) {
        if (!SystemInstance.isInitialized()) {
            return;
        }
        OpenEJBEnricher.enrich((Object)o, (AppContext)this.getAppContext(o.getClass()));
    }

    private AppContext getAppContext(Class<?> clazz) {
        BeanContext context;
        String clazzName = clazz.getName();
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        if (this.deployment != null && this.deployment.get() != null && (context = containerSystem.getBeanContext((Object)(((Deployment)this.deployment.get()).getDescription().getName() + "_" + clazzName))) != null) {
            return context.getModuleContext().getAppContext();
        }
        List appContexts = containerSystem.getAppContexts();
        ClassLoader loader = clazz.getClassLoader();
        for (AppContext app : appContexts) {
            BeanContext context2 = containerSystem.getBeanContext((Object)(app.getId() + "_" + clazzName));
            if (context2 == null || context2.getBeanClass().getClassLoader() != loader) continue;
            return app;
        }
        if (this.deployment != null && this.deployment.get() != null && ((Deployment)this.deployment.get()).getDescription().testable()) {
            Logger.getLogger(TomEEInjectionEnricher.class.getName()).log(Level.WARNING, "Failed to find AppContext for: " + clazzName);
        }
        return null;
    }

    public Object[] resolve(Method method) {
        return OpenEJBEnricher.resolve((AppContext)this.getAppContext(method.getDeclaringClass()), (TestClass)((TestClass)this.testClass.get()), (Method)method);
    }
}

