/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class Files {
    private static final Logger LOGGER = Logger.getLogger(Files.class.getName());
    static final List<String> delete = new ArrayList<String>();
    private static volatile boolean shutdown;

    public static File path(String ... parts) {
        File dir = null;
        for (String part : parts) {
            dir = dir == null ? new File(part) : new File(dir, part);
        }
        return dir;
    }

    public static File path(File dir, String ... parts) {
        for (String part : parts) {
            dir = new File(dir, part);
        }
        return dir;
    }

    public static File createTempDir() throws IOException {
        return Files.createTempDir("tomee", ".conf");
    }

    public static File createTempDir(String prefix, String suffix) throws IOException {
        File tempDir;
        try {
            tempDir = File.createTempFile(prefix, suffix);
        }
        catch (Throwable e) {
            File tmp = new File("tmp");
            if (!tmp.exists() && !tmp.mkdirs()) {
                throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
            }
            tempDir = File.createTempFile(prefix, suffix, tmp);
        }
        if (!tempDir.delete() && tempDir.mkdirs()) {
            throw new IOException("Failed to create temp directory: " + tempDir.getAbsolutePath());
        }
        Files.deleteOnExit(tempDir);
        return tempDir;
    }

    private Files() {
    }

    public static void deleteOnExit(File file) {
        delete.add(file.getAbsolutePath());
    }

    private static void delete() {
        for (String path : delete) {
            Files.delete(new File(path));
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            Files.tryTodelete(file);
            if (!file.delete() && !shutdown) {
                file.deleteOnExit();
            } else if (!Files.willBeDelete(file)) {
                LOGGER.severe("can't delete " + file.getAbsolutePath());
            }
        }
    }

    private static boolean willBeDelete(File file) {
        for (File current = file; current != null; current = current.getParentFile()) {
            if (!delete.contains(current.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public static void mkdir(File dir) {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IllegalStateException("cannot make directory: " + dir.getAbsolutePath());
        }
    }

    public static void writable(File file) {
        if (!file.canWrite()) {
            throw new IllegalStateException("Not writable: " + file.getAbsolutePath());
        }
    }

    public static void readable(File file) {
        if (!file.canRead()) {
            throw new IllegalStateException("Not readable: " + file.getAbsolutePath());
        }
    }

    public static void assertDir(File file) {
        if (!file.isDirectory()) {
            throw new IllegalStateException("Not a directory: " + file.getAbsolutePath());
        }
    }

    public static void assertFile(File file) {
        if (!file.isFile()) {
            throw new IllegalStateException("Not a file: " + file.getAbsolutePath());
        }
    }

    public static void tryTodelete(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                Files.delete(f);
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown = true;
                Files.delete();
            }
        });
    }
}

