/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.tribes.io.ReplicationStream;

public abstract class ClusterManagerBase
extends ManagerBase
implements ClusterManager {
    protected CatalinaCluster cluster = null;
    private boolean notifyListenersOnReplication = true;
    private String sessionAttributeFilter = null;
    private Pattern sessionAttributePattern = null;

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean isNotifyListenersOnReplication() {
        return this.notifyListenersOnReplication;
    }

    public void setNotifyListenersOnReplication(boolean notifyListenersOnReplication) {
        this.notifyListenersOnReplication = notifyListenersOnReplication;
    }

    public String getSessionAttributeFilter() {
        return this.sessionAttributeFilter;
    }

    public void setSessionAttributeFilter(String sessionAttributeFilter) {
        if (sessionAttributeFilter == null || sessionAttributeFilter.trim().equals("")) {
            this.sessionAttributeFilter = null;
            this.sessionAttributePattern = null;
        } else {
            this.sessionAttributeFilter = sessionAttributeFilter;
            this.sessionAttributePattern = Pattern.compile(sessionAttributeFilter);
        }
    }

    public boolean willAttributeDistribute(String name) {
        if (this.sessionAttributePattern == null) {
            return true;
        }
        return this.sessionAttributePattern.matcher(name).matches();
    }

    public static ClassLoader[] getClassLoaders(Context context) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Loader loader = context.getLoader();
        ClassLoader classLoader = null;
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = tccl;
        }
        if (classLoader == tccl) {
            return new ClassLoader[]{classLoader};
        }
        return new ClassLoader[]{classLoader, tccl};
    }

    public ClassLoader[] getClassLoaders() {
        return ClusterManagerBase.getClassLoaders(this.getContext());
    }

    @Override
    public ReplicationStream getReplicationStream(byte[] data) throws IOException {
        return this.getReplicationStream(data, 0, data.length);
    }

    @Override
    public ReplicationStream getReplicationStream(byte[] data, int offset, int length) throws IOException {
        ByteArrayInputStream fis = new ByteArrayInputStream(data, offset, length);
        return new ReplicationStream((InputStream)fis, this.getClassLoaders());
    }

    public void load() {
    }

    public void unload() {
    }

    protected void clone(ClusterManagerBase copy) {
        copy.setName("Clone-from-" + this.getName());
        copy.setCluster(this.getCluster());
        copy.setMaxActiveSessions(this.getMaxActiveSessions());
        copy.setMaxInactiveInterval(this.getMaxInactiveInterval());
        copy.setSessionIdLength(this.getSessionIdLength());
        copy.setProcessExpiresFrequency(this.getProcessExpiresFrequency());
        copy.setNotifyListenersOnReplication(this.isNotifyListenersOnReplication());
        copy.setSessionAttributeFilter(this.getSessionAttributeFilter());
        copy.setSecureRandomClass(this.getSecureRandomClass());
        copy.setSecureRandomProvider(this.getSecureRandomProvider());
        copy.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
    }
}

