/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.Utf8Decoder;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.MessagePart;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationResult;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WrappedMessageHandler;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsPongMessage;
import org.apache.tomcat.websocket.WsSession;

public abstract class WsFrameBase {
    private static final StringManager sm = StringManager.getManager(WsFrameBase.class);
    protected final WsSession wsSession;
    protected final byte[] inputBuffer;
    private final Transformation transformation;
    private final ByteBuffer controlBufferBinary = ByteBuffer.allocate(125);
    private final CharBuffer controlBufferText = CharBuffer.allocate(125);
    private final CharsetDecoder utf8DecoderControl = new Utf8Decoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    private final CharsetDecoder utf8DecoderMessage = new Utf8Decoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    private boolean continuationExpected = false;
    private boolean textMessage = false;
    private ByteBuffer messageBufferBinary;
    private CharBuffer messageBufferText;
    private MessageHandler binaryMsgHandler = null;
    private MessageHandler textMsgHandler = null;
    private boolean fin = false;
    private int rsv = 0;
    private byte opCode = 0;
    private final byte[] mask = new byte[4];
    private int maskIndex = 0;
    private long payloadLength = 0L;
    private volatile long payloadWritten = 0L;
    private volatile State state = State.NEW_FRAME;
    private volatile boolean open = true;
    private volatile int readPos = 0;
    protected volatile int writePos = 0;

    public WsFrameBase(WsSession wsSession, Transformation transformation) {
        this.inputBuffer = new byte[Constants.DEFAULT_BUFFER_SIZE];
        this.messageBufferBinary = ByteBuffer.allocate(wsSession.getMaxBinaryMessageBufferSize());
        this.messageBufferText = CharBuffer.allocate(wsSession.getMaxTextMessageBufferSize());
        this.wsSession = wsSession;
        TerminalTransformation finalTransformation = this.isMasked() ? new UnmaskTransformation() : new NoopTransformation();
        if (transformation == null) {
            this.transformation = finalTransformation;
        } else {
            transformation.setNext(finalTransformation);
            this.transformation = transformation;
        }
    }

    protected void processInputBuffer() throws IOException {
        do {
            this.wsSession.updateLastActive();
            if (this.state != State.NEW_FRAME) continue;
            if (this.processInitialHeader()) {
                if (this.open) continue;
                throw new IOException(sm.getString("wsFrame.closed"));
            }
            break;
        } while ((this.state != State.PARTIAL_HEADER || this.processRemainingHeader()) && (this.state != State.DATA || this.processData()));
    }

    private boolean processInitialHeader() throws IOException {
        byte b;
        if (this.writePos - this.readPos < 2) {
            return false;
        }
        this.fin = ((b = this.inputBuffer[this.readPos++]) & 0x80) > 0;
        this.rsv = (b & 0x70) >>> 4;
        this.opCode = (byte)(b & 0xF);
        if (!this.transformation.validateRsv(this.rsv, this.opCode)) {
            throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.wrongRsv", new Object[]{this.rsv, (int)this.opCode})));
        }
        if (Util.isControl(this.opCode)) {
            if (!this.fin) {
                throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.controlFragmented")));
            }
            if (this.opCode != 9 && this.opCode != 10 && this.opCode != 8) {
                throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.invalidOpCode", new Object[]{(int)this.opCode})));
            }
        } else {
            block16: {
                if (this.continuationExpected) {
                    if (!Util.isContinuation(this.opCode)) {
                        throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.noContinuation")));
                    }
                } else {
                    try {
                        if (this.opCode == 2) {
                            this.textMessage = false;
                            int size = this.wsSession.getMaxBinaryMessageBufferSize();
                            if (size != this.messageBufferBinary.capacity()) {
                                this.messageBufferBinary = ByteBuffer.allocate(size);
                            }
                            this.binaryMsgHandler = this.wsSession.getBinaryMessageHandler();
                            this.textMsgHandler = null;
                            break block16;
                        }
                        if (this.opCode == 1) {
                            this.textMessage = true;
                            int size = this.wsSession.getMaxTextMessageBufferSize();
                            if (size != this.messageBufferText.capacity()) {
                                this.messageBufferText = CharBuffer.allocate(size);
                            }
                            this.binaryMsgHandler = null;
                            this.textMsgHandler = this.wsSession.getTextMessageHandler();
                            break block16;
                        }
                        throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.invalidOpCode", new Object[]{(int)this.opCode})));
                    }
                    catch (IllegalStateException ise) {
                        throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.sessionClosed")));
                    }
                }
            }
            boolean bl = this.continuationExpected = !this.fin;
        }
        if (((b = this.inputBuffer[this.readPos++]) & 0x80) == 0 && this.isMasked()) {
            throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.notMasked")));
        }
        this.payloadLength = b & 0x7F;
        this.state = State.PARTIAL_HEADER;
        return true;
    }

    protected abstract boolean isMasked();

    private boolean processRemainingHeader() throws IOException {
        int headerLength = this.isMasked() ? 4 : 0;
        if (this.payloadLength == 126L) {
            headerLength += 2;
        } else if (this.payloadLength == 127L) {
            headerLength += 8;
        }
        if (this.writePos - this.readPos < headerLength) {
            return false;
        }
        if (this.payloadLength == 126L) {
            this.payloadLength = WsFrameBase.byteArrayToLong(this.inputBuffer, this.readPos, 2);
            this.readPos += 2;
        } else if (this.payloadLength == 127L) {
            this.payloadLength = WsFrameBase.byteArrayToLong(this.inputBuffer, this.readPos, 8);
            this.readPos += 8;
        }
        if (Util.isControl(this.opCode)) {
            if (this.payloadLength > 125L) {
                throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.controlPayloadTooBig", new Object[]{this.payloadLength})));
            }
            if (!this.fin) {
                throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.controlNoFin")));
            }
        }
        if (this.isMasked()) {
            System.arraycopy(this.inputBuffer, this.readPos, this.mask, 0, 4);
            this.readPos += 4;
        }
        this.state = State.DATA;
        return true;
    }

    private boolean processData() throws IOException {
        boolean result = Util.isControl(this.opCode) ? this.processDataControl() : (this.textMessage ? (this.textMsgHandler == null ? this.swallowInput() : this.processDataText()) : (this.binaryMsgHandler == null ? this.swallowInput() : this.processDataBinary()));
        this.checkRoomPayload();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processDataControl() throws IOException {
        TransformationResult tr = this.transformation.getMoreData(this.opCode, this.fin, this.rsv, this.controlBufferBinary);
        if (TransformationResult.UNDERFLOW.equals((Object)tr)) {
            return false;
        }
        this.controlBufferBinary.flip();
        if (this.opCode == 8) {
            this.open = false;
            String reason = null;
            int code = CloseReason.CloseCodes.NORMAL_CLOSURE.getCode();
            if (this.controlBufferBinary.remaining() == 1) {
                this.controlBufferBinary.clear();
                throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.oneByteCloseCode")));
            }
            if (this.controlBufferBinary.remaining() > 1) {
                code = this.controlBufferBinary.getShort();
                if (this.controlBufferBinary.remaining() > 0) {
                    CoderResult cr = this.utf8DecoderControl.decode(this.controlBufferBinary, this.controlBufferText, true);
                    if (cr.isError()) {
                        this.controlBufferBinary.clear();
                        this.controlBufferText.clear();
                        throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.invalidUtf8Close")));
                    }
                    this.controlBufferText.flip();
                    reason = this.controlBufferText.toString();
                }
            }
            this.wsSession.onClose(new CloseReason(Util.getCloseCode(code), reason));
        } else if (this.opCode == 9) {
            if (this.wsSession.isOpen()) {
                this.wsSession.getBasicRemote().sendPong(this.controlBufferBinary);
            }
        } else if (this.opCode == 10) {
            MessageHandler.Whole<PongMessage> mhPong = this.wsSession.getPongMessageHandler();
            if (mhPong != null) {
                try {
                    mhPong.onMessage(new WsPongMessage(this.controlBufferBinary));
                }
                catch (Throwable t) {
                    this.handleThrowableOnSend(t);
                }
                finally {
                    this.controlBufferBinary.clear();
                }
            }
        } else {
            this.controlBufferBinary.clear();
            throw new WsIOException(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.invalidOpCode", new Object[]{(int)this.opCode})));
        }
        this.controlBufferBinary.clear();
        this.newFrame();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageText(boolean last) throws WsIOException {
        long maxMessageSize;
        if (this.textMsgHandler instanceof WrappedMessageHandler && (maxMessageSize = ((WrappedMessageHandler)((Object)this.textMsgHandler)).getMaxMessageSize()) > -1L && (long)this.messageBufferText.remaining() > maxMessageSize) {
            throw new WsIOException(new CloseReason(CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.messageTooBig", new Object[]{(long)this.messageBufferText.remaining(), maxMessageSize})));
        }
        try {
            if (this.textMsgHandler instanceof MessageHandler.Partial) {
                ((MessageHandler.Partial)this.textMsgHandler).onMessage(this.messageBufferText.toString(), last);
            } else {
                ((MessageHandler.Whole)this.textMsgHandler).onMessage(this.messageBufferText.toString());
            }
        }
        catch (Throwable t) {
            this.handleThrowableOnSend(t);
        }
        finally {
            this.messageBufferText.clear();
        }
    }

    private boolean processDataText() throws IOException {
        TransformationResult tr = this.transformation.getMoreData(this.opCode, this.fin, this.rsv, this.messageBufferBinary);
        while (!TransformationResult.END_OF_FRAME.equals((Object)tr)) {
            this.messageBufferBinary.flip();
            while (true) {
                CoderResult cr;
                if ((cr = this.utf8DecoderMessage.decode(this.messageBufferBinary, this.messageBufferText, false)).isError()) {
                    throw new WsIOException(new CloseReason(CloseReason.CloseCodes.NOT_CONSISTENT, sm.getString("wsFrame.invalidUtf8")));
                }
                if (cr.isOverflow()) {
                    if (this.usePartial()) {
                        this.messageBufferText.flip();
                        this.sendMessageText(false);
                        this.messageBufferText.clear();
                        continue;
                    }
                    throw new WsIOException(new CloseReason(CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.textMessageTooBig")));
                }
                if (cr.isUnderflow()) break;
            }
            this.messageBufferBinary.compact();
            if (!TransformationResult.OVERFLOW.equals((Object)tr)) {
                return false;
            }
            tr = this.transformation.getMoreData(this.opCode, this.fin, this.rsv, this.messageBufferBinary);
        }
        this.messageBufferBinary.flip();
        boolean last = false;
        while (true) {
            CoderResult cr;
            if ((cr = this.utf8DecoderMessage.decode(this.messageBufferBinary, this.messageBufferText, last)).isError()) {
                throw new WsIOException(new CloseReason(CloseReason.CloseCodes.NOT_CONSISTENT, sm.getString("wsFrame.invalidUtf8")));
            }
            if (cr.isOverflow()) {
                if (this.usePartial()) {
                    this.messageBufferText.flip();
                    this.sendMessageText(false);
                    this.messageBufferText.clear();
                    continue;
                }
                throw new WsIOException(new CloseReason(CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.textMessageTooBig")));
            }
            if (!cr.isUnderflow() || last) break;
            if (this.continuationExpected) {
                if (this.usePartial()) {
                    this.messageBufferText.flip();
                    this.sendMessageText(false);
                    this.messageBufferText.clear();
                }
                this.messageBufferBinary.compact();
                this.newFrame();
                return true;
            }
            last = true;
        }
        this.messageBufferText.flip();
        this.sendMessageText(true);
        this.newMessage();
        return true;
    }

    private boolean processDataBinary() throws IOException {
        ByteBuffer copy;
        TransformationResult tr = this.transformation.getMoreData(this.opCode, this.fin, this.rsv, this.messageBufferBinary);
        while (!TransformationResult.END_OF_FRAME.equals((Object)tr)) {
            if (TransformationResult.UNDERFLOW.equals((Object)tr)) {
                return false;
            }
            if (!this.usePartial()) {
                CloseReason cr = new CloseReason(CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.bufferTooSmall", new Object[]{this.messageBufferBinary.capacity(), this.payloadLength}));
                throw new WsIOException(cr);
            }
            this.messageBufferBinary.flip();
            copy = ByteBuffer.allocate(this.messageBufferBinary.limit());
            copy.put(this.messageBufferBinary);
            copy.flip();
            this.sendMessageBinary(copy, false);
            this.messageBufferBinary.clear();
            tr = this.transformation.getMoreData(this.opCode, this.fin, this.rsv, this.messageBufferBinary);
        }
        if (this.usePartial() || !this.continuationExpected) {
            this.messageBufferBinary.flip();
            copy = ByteBuffer.allocate(this.messageBufferBinary.limit());
            copy.put(this.messageBufferBinary);
            copy.flip();
            this.sendMessageBinary(copy, !this.continuationExpected);
            this.messageBufferBinary.clear();
        }
        if (this.continuationExpected) {
            this.newFrame();
        } else {
            this.newMessage();
        }
        return true;
    }

    private void handleThrowableOnSend(Throwable t) throws WsIOException {
        ExceptionUtils.handleThrowable((Throwable)t);
        this.wsSession.getLocal().onError(this.wsSession, t);
        CloseReason cr = new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, sm.getString("wsFrame.ioeTriggeredClose"));
        throw new WsIOException(cr);
    }

    private void sendMessageBinary(ByteBuffer msg, boolean last) throws WsIOException {
        long maxMessageSize;
        if (this.binaryMsgHandler instanceof WrappedMessageHandler && (maxMessageSize = ((WrappedMessageHandler)((Object)this.binaryMsgHandler)).getMaxMessageSize()) > -1L && (long)msg.remaining() > maxMessageSize) {
            throw new WsIOException(new CloseReason(CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.messageTooBig", new Object[]{(long)msg.remaining(), maxMessageSize})));
        }
        try {
            if (this.binaryMsgHandler instanceof MessageHandler.Partial) {
                ((MessageHandler.Partial)this.binaryMsgHandler).onMessage(msg, last);
            } else {
                ((MessageHandler.Whole)this.binaryMsgHandler).onMessage(msg);
            }
        }
        catch (Throwable t) {
            this.handleThrowableOnSend(t);
        }
    }

    private void newMessage() {
        this.messageBufferBinary.clear();
        this.messageBufferText.clear();
        this.utf8DecoderMessage.reset();
        this.continuationExpected = false;
        this.newFrame();
    }

    private void newFrame() {
        if (this.readPos == this.writePos) {
            this.readPos = 0;
            this.writePos = 0;
        }
        this.maskIndex = 0;
        this.payloadWritten = 0L;
        this.state = State.NEW_FRAME;
        this.checkRoomHeaders();
    }

    private void checkRoomHeaders() {
        if (this.inputBuffer.length - this.readPos < 131) {
            this.makeRoom();
        }
    }

    private void checkRoomPayload() {
        if ((long)(this.inputBuffer.length - this.readPos) - this.payloadLength + this.payloadWritten < 0L) {
            this.makeRoom();
        }
    }

    private void makeRoom() {
        System.arraycopy(this.inputBuffer, this.readPos, this.inputBuffer, 0, this.writePos - this.readPos);
        this.writePos -= this.readPos;
        this.readPos = 0;
    }

    private boolean usePartial() {
        if (Util.isControl(this.opCode)) {
            return false;
        }
        if (this.textMessage) {
            return this.textMsgHandler instanceof MessageHandler.Partial;
        }
        return this.binaryMsgHandler instanceof MessageHandler.Partial;
    }

    private boolean swallowInput() {
        long toSkip = Math.min(this.payloadLength - this.payloadWritten, (long)(this.writePos - this.readPos));
        this.readPos = (int)((long)this.readPos + toSkip);
        this.payloadWritten += toSkip;
        if (this.payloadWritten == this.payloadLength) {
            if (this.continuationExpected) {
                this.newFrame();
            } else {
                this.newMessage();
            }
            return true;
        }
        return false;
    }

    protected static long byteArrayToLong(byte[] b, int start, int len) throws IOException {
        if (len > 8) {
            throw new IOException(sm.getString("wsFrame.byteToLongFail", new Object[]{(long)len}));
        }
        int shift = 0;
        long result = 0L;
        for (int i = start + len - 1; i >= start; --i) {
            result += (long)((b[i] & 0xFF) << shift);
            shift += 8;
        }
        return result;
    }

    protected boolean isOpen() {
        return this.open;
    }

    protected Transformation getTransformation() {
        return this.transformation;
    }

    private final class UnmaskTransformation
    extends TerminalTransformation {
        private UnmaskTransformation() {
        }

        @Override
        public TransformationResult getMoreData(byte opCode, boolean fin, int rsv, ByteBuffer dest) {
            while (WsFrameBase.this.payloadWritten < WsFrameBase.this.payloadLength && WsFrameBase.this.readPos < WsFrameBase.this.writePos && dest.hasRemaining()) {
                byte b = (byte)((WsFrameBase.this.inputBuffer[WsFrameBase.this.readPos] ^ WsFrameBase.this.mask[WsFrameBase.this.maskIndex]) & 0xFF);
                WsFrameBase.this.maskIndex++;
                if (WsFrameBase.this.maskIndex == 4) {
                    WsFrameBase.this.maskIndex = 0;
                }
                WsFrameBase.this.readPos++;
                WsFrameBase.this.payloadWritten++;
                dest.put(b);
            }
            if (WsFrameBase.this.payloadWritten == WsFrameBase.this.payloadLength) {
                return TransformationResult.END_OF_FRAME;
            }
            if (WsFrameBase.this.readPos == WsFrameBase.this.writePos) {
                return TransformationResult.UNDERFLOW;
            }
            return TransformationResult.OVERFLOW;
        }

        @Override
        public List<MessagePart> sendMessagePart(List<MessagePart> messageParts) {
            return messageParts;
        }
    }

    private final class NoopTransformation
    extends TerminalTransformation {
        private NoopTransformation() {
        }

        @Override
        public TransformationResult getMoreData(byte opCode, boolean fin, int rsv, ByteBuffer dest) {
            long toWrite = Math.min(WsFrameBase.this.payloadLength - WsFrameBase.this.payloadWritten, (long)(WsFrameBase.this.writePos - WsFrameBase.this.readPos));
            toWrite = Math.min(toWrite, (long)dest.remaining());
            dest.put(WsFrameBase.this.inputBuffer, WsFrameBase.this.readPos, (int)toWrite);
            WsFrameBase.this.readPos = (int)((long)WsFrameBase.this.readPos + toWrite);
            WsFrameBase.this.payloadWritten = WsFrameBase.this.payloadWritten + toWrite;
            if (WsFrameBase.this.payloadWritten == WsFrameBase.this.payloadLength) {
                return TransformationResult.END_OF_FRAME;
            }
            if (WsFrameBase.this.readPos == WsFrameBase.this.writePos) {
                return TransformationResult.UNDERFLOW;
            }
            return TransformationResult.OVERFLOW;
        }

        @Override
        public List<MessagePart> sendMessagePart(List<MessagePart> messageParts) {
            return messageParts;
        }
    }

    private abstract class TerminalTransformation
    implements Transformation {
        private TerminalTransformation() {
        }

        @Override
        public boolean validateRsvBits(int i) {
            return true;
        }

        @Override
        public Extension getExtensionResponse() {
            return null;
        }

        @Override
        public void setNext(Transformation t) {
        }

        @Override
        public boolean validateRsv(int rsv, byte opCode) {
            return rsv == 0;
        }
    }

    private static enum State {
        NEW_FRAME,
        PARTIAL_HEADER,
        DATA;

    }
}

