/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.WsWebSocketContainer;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;
import org.apache.tomcat.websocket.server.Constants;
import org.apache.tomcat.websocket.server.UpgradeUtil;
import org.apache.tomcat.websocket.server.UriTemplate;
import org.apache.tomcat.websocket.server.WsFilter;
import org.apache.tomcat.websocket.server.WsMappingResult;
import org.apache.tomcat.websocket.server.WsWriteTimeout;

public class WsServerContainer
extends WsWebSocketContainer
implements ServerContainer {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static final Log log = LogFactory.getLog(WsServerContainer.class);
    private static final CloseReason AUTHENTICATED_HTTP_SESSION_CLOSED = new CloseReason(CloseReason.CloseCodes.VIOLATED_POLICY, "This connection was established under an authenticated HTTP session that has ended.");
    private final WsWriteTimeout wsWriteTimeout = new WsWriteTimeout();
    private final ServletContext servletContext;
    private final Map<String, ServerEndpointConfig> configExactMatchMap = new ConcurrentHashMap<String, ServerEndpointConfig>();
    private final ConcurrentHashMap<Integer, SortedSet<TemplatePathMatch>> configTemplateMatchMap = new ConcurrentHashMap();
    private volatile boolean enforceNoAddAfterHandshake = org.apache.tomcat.websocket.Constants.STRICT_SPEC_COMPLIANCE;
    private volatile boolean addAllowed = true;
    private final ConcurrentHashMap<String, Set<WsSession>> authenticatedSessions = new ConcurrentHashMap();
    private final ExecutorService executorService;
    private final ThreadGroup threadGroup;
    private volatile boolean endpointsRegistered = false;

    WsServerContainer(ServletContext servletContext) {
        this.servletContext = servletContext;
        String value = servletContext.getInitParameter("org.apache.tomcat.websocket.binaryBufferSize");
        if (value != null) {
            this.setDefaultMaxBinaryMessageBufferSize(Integer.parseInt(value));
        }
        if ((value = servletContext.getInitParameter("org.apache.tomcat.websocket.textBufferSize")) != null) {
            this.setDefaultMaxTextMessageBufferSize(Integer.parseInt(value));
        }
        if ((value = servletContext.getInitParameter("org.apache.tomcat.websocket.noAddAfterHandshake")) != null) {
            this.setEnforceNoAddAfterHandshake(Boolean.parseBoolean(value));
        }
        int executorCoreSize = 0;
        long executorKeepAliveTimeSeconds = 60L;
        value = servletContext.getInitParameter("org.apache.tomcat.websocket.executorCoreSize");
        if (value != null) {
            executorCoreSize = Integer.parseInt(value);
        }
        if ((value = servletContext.getInitParameter("org.apache.tomcat.websocket.executorKeepAliveTimeSeconds")) != null) {
            executorKeepAliveTimeSeconds = Long.parseLong(value);
        }
        FilterRegistration.Dynamic fr = servletContext.addFilter("Tomcat WebSocket (JSR356) Filter", (Filter)new WsFilter());
        fr.setAsyncSupported(true);
        EnumSet<DispatcherType> types = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD);
        fr.addMappingForUrlPatterns(types, true, new String[]{"/*"});
        StringBuffer threadGroupName = new StringBuffer("WebSocketServer-");
        if ("".equals(servletContext.getContextPath())) {
            threadGroupName.append("ROOT");
        } else {
            threadGroupName.append(servletContext.getContextPath());
        }
        this.threadGroup = new ThreadGroup(threadGroupName.toString());
        WsThreadFactory wsThreadFactory = new WsThreadFactory(this.threadGroup);
        this.executorService = new ThreadPoolExecutor(executorCoreSize, Integer.MAX_VALUE, executorKeepAliveTimeSeconds, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), wsThreadFactory);
    }

    @Override
    public void addEndpoint(ServerEndpointConfig sec) throws DeploymentException {
        UriTemplate uriTemplate;
        if (this.enforceNoAddAfterHandshake && !this.addAllowed) {
            throw new DeploymentException(sm.getString("serverContainer.addNotAllowed"));
        }
        if (this.servletContext == null) {
            throw new DeploymentException(sm.getString("serverContainer.servletContextMissing"));
        }
        String path = sec.getPath();
        PojoMethodMapping methodMapping = new PojoMethodMapping(sec.getEndpointClass(), sec.getDecoders(), path);
        if (methodMapping.getOnClose() != null || methodMapping.getOnOpen() != null || methodMapping.getOnError() != null || methodMapping.hasMessageHandlers()) {
            sec.getUserProperties().put("org.apache.tomcat.websocket.pojo.PojoEndpoint.methodMapping", methodMapping);
        }
        if ((uriTemplate = new UriTemplate(path)).hasParameters()) {
            Integer key = uriTemplate.getSegmentCount();
            SortedSet<TemplatePathMatch> templateMatches = this.configTemplateMatchMap.get(key);
            if (templateMatches == null) {
                templateMatches = new TreeSet<TemplatePathMatch>(TemplatePathMatchComparator.getInstance());
                this.configTemplateMatchMap.putIfAbsent(key, templateMatches);
                templateMatches = this.configTemplateMatchMap.get(key);
            }
            if (!templateMatches.add(new TemplatePathMatch(sec, uriTemplate))) {
                throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", new Object[]{path, sec.getEndpointClass(), sec.getEndpointClass()}));
            }
        } else {
            ServerEndpointConfig old = this.configExactMatchMap.put(path, sec);
            if (old != null) {
                throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", new Object[]{path, old.getEndpointClass(), sec.getEndpointClass()}));
            }
        }
        this.endpointsRegistered = true;
    }

    @Override
    public void addEndpoint(Class<?> pojo) throws DeploymentException {
        ServerEndpoint annotation = pojo.getAnnotation(ServerEndpoint.class);
        if (annotation == null) {
            throw new DeploymentException(sm.getString("serverContainer.missingAnnotation", new Object[]{pojo.getName()}));
        }
        String path = annotation.value();
        WsServerContainer.validateEncoders(annotation.encoders());
        Class<? extends ServerEndpointConfig.Configurator> configuratorClazz = annotation.configurator();
        ServerEndpointConfig.Configurator configurator = null;
        if (!configuratorClazz.equals(ServerEndpointConfig.Configurator.class)) {
            try {
                configurator = annotation.configurator().newInstance();
            }
            catch (InstantiationException e) {
                throw new DeploymentException(sm.getString("serverContainer.configuratorFail", new Object[]{annotation.configurator().getName(), pojo.getClass().getName()}), e);
            }
            catch (IllegalAccessException e) {
                throw new DeploymentException(sm.getString("serverContainer.configuratorFail", new Object[]{annotation.configurator().getName(), pojo.getClass().getName()}), e);
            }
        }
        ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(pojo, path).decoders(Arrays.asList(annotation.decoders())).encoders(Arrays.asList(annotation.encoders())).subprotocols(Arrays.asList(annotation.subprotocols())).configurator(configurator).build();
        this.addEndpoint(sec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() {
        this.shutdownExecutor();
        super.destroy();
        int threadCount = this.threadGroup.activeCount();
        boolean success = false;
        try {
            while (true) {
                int oldThreadCount = threadCount;
                ThreadGroup threadGroup = this.threadGroup;
                synchronized (threadGroup) {
                    if (threadCount > 0) {
                        Thread.yield();
                        threadCount = this.threadGroup.activeCount();
                    }
                    if (threadCount <= 0 || threadCount == oldThreadCount) break;
                }
            }
            {
                if (threadCount <= 0) {
                    this.threadGroup.destroy();
                    return;
                }
                this.threadGroup.setDaemon(true);
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        if (success) return;
        log.warn((Object)sm.getString("serverContainer.threadGroupNotDestroyed", new Object[]{this.threadGroup.getName(), threadCount}));
    }

    boolean areEndpointsRegistered() {
        return this.endpointsRegistered;
    }

    public void doUpgrade(HttpServletRequest request, HttpServletResponse response, ServerEndpointConfig sec, Map<String, String> pathParams) throws ServletException, IOException {
        UpgradeUtil.doUpgrade(this, request, response, sec, pathParams);
    }

    public WsMappingResult findMapping(String path) {
        ServerEndpointConfig sec;
        if (this.addAllowed) {
            this.addAllowed = false;
        }
        if ((sec = this.configExactMatchMap.get(path)) != null) {
            return new WsMappingResult(sec, Collections.<String, String>emptyMap());
        }
        UriTemplate pathUriTemplate = null;
        try {
            pathUriTemplate = new UriTemplate(path);
        }
        catch (DeploymentException e) {
            return null;
        }
        Integer key = pathUriTemplate.getSegmentCount();
        SortedSet<TemplatePathMatch> templateMatches = this.configTemplateMatchMap.get(key);
        if (templateMatches == null) {
            return null;
        }
        Map<String, String> pathParams = null;
        for (TemplatePathMatch templateMatch : templateMatches) {
            pathParams = templateMatch.getUriTemplate().match(pathUriTemplate);
            if (pathParams == null) continue;
            sec = templateMatch.getConfig();
            break;
        }
        if (sec == null) {
            return null;
        }
        return new WsMappingResult(sec, pathParams);
    }

    public boolean isEnforceNoAddAfterHandshake() {
        return this.enforceNoAddAfterHandshake;
    }

    public void setEnforceNoAddAfterHandshake(boolean enforceNoAddAfterHandshake) {
        this.enforceNoAddAfterHandshake = enforceNoAddAfterHandshake;
    }

    protected WsWriteTimeout getTimeout() {
        return this.wsWriteTimeout;
    }

    @Override
    protected void registerSession(Endpoint endpoint, WsSession wsSession) {
        super.registerSession(endpoint, wsSession);
        if (wsSession.isOpen() && wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.registerAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
        }
    }

    @Override
    protected void unregisterSession(Endpoint endpoint, WsSession wsSession) {
        if (wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.unregisterAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
        }
        super.unregisterSession(endpoint, wsSession);
    }

    private void registerAuthenticatedSession(WsSession wsSession, String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.get(httpSessionId);
        if (wsSessions == null) {
            wsSessions = Collections.newSetFromMap(new ConcurrentHashMap());
            this.authenticatedSessions.putIfAbsent(httpSessionId, wsSessions);
            wsSessions = this.authenticatedSessions.get(httpSessionId);
        }
        wsSessions.add(wsSession);
    }

    private void unregisterAuthenticatedSession(WsSession wsSession, String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.get(httpSessionId);
        if (wsSessions != null) {
            wsSessions.remove(wsSession);
        }
    }

    public void closeAuthenticatedSession(String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.remove(httpSessionId);
        if (wsSessions != null && !wsSessions.isEmpty()) {
            for (WsSession wsSession : wsSessions) {
                try {
                    wsSession.close(AUTHENTICATED_HTTP_SESSION_CLOSED);
                }
                catch (IOException iOException) {}
            }
        }
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    private void shutdownExecutor() {
        if (this.executorService == null) {
            return;
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void validateEncoders(Class<? extends Encoder>[] encoders) throws DeploymentException {
        for (Class<? extends Encoder> encoder : encoders) {
            try {
                encoder.newInstance();
            }
            catch (InstantiationException e) {
                throw new DeploymentException(sm.getString("serverContainer.encoderFail", new Object[]{encoder.getName()}), e);
            }
            catch (IllegalAccessException e) {
                throw new DeploymentException(sm.getString("serverContainer.encoderFail", new Object[]{encoder.getName()}), e);
            }
        }
    }

    private static class WsThreadFactory
    implements ThreadFactory {
        private final ThreadGroup tg;
        private final AtomicLong count = new AtomicLong(0L);

        private WsThreadFactory(ThreadGroup tg) {
            this.tg = tg;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.tg, r);
            t.setName(this.tg.getName() + "-" + this.count.incrementAndGet());
            return t;
        }
    }

    private static class TemplatePathMatchComparator
    implements Comparator<TemplatePathMatch> {
        private static final TemplatePathMatchComparator INSTANCE = new TemplatePathMatchComparator();

        public static TemplatePathMatchComparator getInstance() {
            return INSTANCE;
        }

        private TemplatePathMatchComparator() {
        }

        @Override
        public int compare(TemplatePathMatch tpm1, TemplatePathMatch tpm2) {
            return tpm1.getUriTemplate().getNormalizedPath().compareTo(tpm2.getUriTemplate().getNormalizedPath());
        }
    }

    private static class TemplatePathMatch {
        private final ServerEndpointConfig config;
        private final UriTemplate uriTemplate;

        public TemplatePathMatch(ServerEndpointConfig config, UriTemplate uriTemplate) {
            this.config = config;
            this.uriTemplate = uriTemplate;
        }

        public ServerEndpointConfig getConfig() {
            return this.config;
        }

        public UriTemplate getUriTemplate() {
            return this.uriTemplate;
        }
    }
}

