/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.Response;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.UnpackerResource;
import org.apache.tika.server.core.writer.TarWriter;
import org.apache.tika.server.core.writer.ZipWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnpackerResourceWithConfigTest
extends CXFTestBase {
    private static final String BASE_PATH = "/unpack";
    private static final String ALL_PATH = "/unpack/all";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{UnpackerResource.class});
        sf.setResourceProvider(UnpackerResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new UnpackerResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TarWriter());
        providers.add(new ZipWriter());
        providers.add(new TikaServerParseExceptionMapper(false));
        sf.setProviders(providers);
    }

    protected InputStream getTikaConfigInputStream() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/config/tika-config-unpacker.xml");
    }

    @Test
    public void testPDFPerPageRenderColor() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack/all").header("X-Tika-PDFimageStrategy", new Object[]{"RenderPagesAtPageEnd"}).header("X-Tika-PDFocrImageType", new Object[]{"rgb"}).header("X-Tika-PDFocrImageFormatName", new Object[]{"tiff"}).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testColorRendering.pdf"));
        Map results = this.readZipArchiveBytes((InputStream)response.getEntity());
        byte[] renderedImage = null;
        for (Map.Entry e : results.entrySet()) {
            if (!((String)e.getKey()).startsWith("tika-pdfbox-rendering")) continue;
            renderedImage = (byte[])e.getValue();
            break;
        }
        Assertions.assertEquals((Object)"image/tiff", (Object)TikaConfig.getDefaultConfig().getDetector().detect((InputStream)new ByteArrayInputStream(renderedImage), new Metadata()).toString());
        try (ByteArrayInputStream is = new ByteArrayInputStream(renderedImage);){
            BufferedImage image = ImageIO.read(is);
            CXFTestBase.AverageColor averageColor = UnpackerResourceWithConfigTest.getAverageColor((BufferedImage)image, (int)0, (int)(image.getWidth() / 5), (int)0, (int)(image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() > 250.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() < 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() < 1.0 ? 1 : 0) != 0);
            averageColor = UnpackerResourceWithConfigTest.getAverageColor((BufferedImage)image, (int)0, (int)(image.getWidth() / 5), (int)(image.getHeight() / 2 + image.getHeight() / 10), (int)(image.getHeight() / 2 + 2 * image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() < 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() > 250.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() < 1.0 ? 1 : 0) != 0);
            averageColor = UnpackerResourceWithConfigTest.getAverageColor((BufferedImage)image, (int)(image.getWidth() / 2 + image.getWidth() / 10), (int)(image.getWidth() / 2 + 2 * image.getWidth() / 10), (int)(image.getHeight() / 2 + image.getHeight() / 10), (int)(image.getHeight() / 2 + 2 * image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() < 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() < 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() > 250.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPDFPerPageRenderGray() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack/all").header("X-Tika-PDFimageStrategy", new Object[]{"RenderPagesAtPageEnd"}).header("X-Tika-PDFocrImageType", new Object[]{"gray"}).header("X-Tika-PDFocrImageFormatName", new Object[]{"jpeg"}).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testColorRendering.pdf"));
        Map results = this.readZipArchiveBytes((InputStream)response.getEntity());
        byte[] renderedImage = null;
        for (Map.Entry e : results.entrySet()) {
            if (!((String)e.getKey()).startsWith("tika-pdfbox-rendering")) continue;
            renderedImage = (byte[])e.getValue();
            break;
        }
        Assertions.assertEquals((Object)"image/jpeg", (Object)TikaConfig.getDefaultConfig().getDetector().detect((InputStream)new ByteArrayInputStream(renderedImage), new Metadata()).toString());
        try (ByteArrayInputStream is = new ByteArrayInputStream(renderedImage);){
            BufferedImage image = ImageIO.read(is);
            CXFTestBase.AverageColor averageColor = UnpackerResourceWithConfigTest.getAverageColor((BufferedImage)image, (int)0, (int)(image.getWidth() / 5), (int)0, (int)(image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() > 140.0 && averageColor.getRed() < 160.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() > 140.0 && averageColor.getGreen() < 160.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() > 140.0 && averageColor.getBlue() < 160.0 ? 1 : 0) != 0);
            averageColor = UnpackerResourceWithConfigTest.getAverageColor((BufferedImage)image, (int)0, (int)(image.getWidth() / 5), (int)(image.getHeight() / 2 + image.getHeight() / 10), (int)(image.getHeight() / 2 + 2 * image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() < 210.0 && averageColor.getRed() > 190.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() < 210.0 && averageColor.getGreen() > 190.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() < 210.0 && averageColor.getBlue() > 190.0 ? 1 : 0) != 0);
            averageColor = UnpackerResourceWithConfigTest.getAverageColor((BufferedImage)image, (int)(image.getWidth() / 2 + image.getWidth() / 10), (int)(image.getWidth() / 2 + 2 * image.getWidth() / 10), (int)(image.getHeight() / 2 + image.getHeight() / 10), (int)(image.getHeight() / 2 + 2 * image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() < 100.0 && averageColor.getRed() > 90.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() < 100.0 && averageColor.getGreen() > 90.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() < 100.0 && averageColor.getBlue() > 90.0 ? 1 : 0) != 0);
        }
    }
}

