/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.Response;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.UnpackerResource;
import org.apache.tika.server.core.writer.TarWriter;
import org.apache.tika.server.core.writer.ZipWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class UnpackerResourceTest
extends CXFTestBase {
    private static final String BASE_PATH = "/unpack";
    private static final String UNPACKER_PATH = "/unpack";
    private static final String ALL_PATH = "/unpack/all";
    private static final String TEST_DOC_WAV = "test-documents/Doc1_ole.doc";
    private static final String WAV1_MD5 = "bdd0a78a54968e362445364f95d8dc96";
    private static final String WAV1_NAME = "_1310388059/MSj00974840000[1].wav";
    private static final String WAV2_MD5 = "3bbd42fb1ac0e46a95350285f16d9596";
    private static final String WAV2_NAME = "_1310388058/MSj00748450000[1].wav";
    private static final String JPG_NAME = "image1.jpg";
    private static final String XSL_IMAGE1_MD5 = "68ead8f4995a3555f48a2f738b2b0c3d";
    private static final String JPG_MD5 = "68ead8f4995a3555f48a2f738b2b0c3d";
    private static final String JPG2_NAME = "image2.jpg";
    private static final String JPG2_MD5 = "b27a41d12c646d7fc4f3826cf8183c68";
    private static final String TEST_DOCX_IMAGE = "test-documents/2pic.docx";
    private static final String DOCX_IMAGE1_MD5 = "5516590467b069fa59397432677bad4d";
    private static final String DOCX_IMAGE2_MD5 = "a5dd81567427070ce0a2ff3e3ef13a4c";
    private static final String DOCX_IMAGE1_NAME = "image1.jpeg";
    private static final String DOCX_IMAGE2_NAME = "image2.jpeg";
    private static final String DOCX_EXE1_MD5 = "d71ffa0623014df725f8fd2710de4411";
    private static final String DOCX_EXE1_NAME = "GMapTool.exe";
    private static final String DOCX_EXE2_MD5 = "2485435c7c22d35f2de9b4c98c0c2e1a";
    private static final String DOCX_EXE2_NAME = "Setup.exe";
    private static final String XSL_IMAGE2_MD5 = "8969288f4245120e7c3870287cce0ff3";
    private static final String APPLICATION_MSWORD = "application/msword";
    private static final String APPLICATION_XML = "application/xml";
    private static final String CONTENT_TYPE = "Content-type";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{UnpackerResource.class});
        sf.setResourceProvider(UnpackerResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new UnpackerResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TarWriter());
        providers.add(new ZipWriter());
        providers.add(new TikaServerParseExceptionMapper(false));
        sf.setProviders(providers);
    }

    @Test
    public void testDocWAV() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack").type(APPLICATION_MSWORD).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC_WAV));
        Map data = this.readZipArchive((InputStream)response.getEntity());
        Assertions.assertEquals((Object)WAV1_MD5, data.get(WAV1_NAME));
        Assertions.assertEquals((Object)WAV2_MD5, data.get(WAV2_NAME));
        Assertions.assertFalse((boolean)data.containsKey("__TEXT__"));
    }

    @Test
    public void testDocWAVText() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack/all").type(APPLICATION_MSWORD).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC_WAV));
        Map data = this.readZipArchive((InputStream)response.getEntity());
        Assertions.assertEquals((Object)WAV1_MD5, data.get(WAV1_NAME));
        Assertions.assertEquals((Object)WAV2_MD5, data.get(WAV2_NAME));
        Assertions.assertTrue((boolean)data.containsKey("__TEXT__"));
    }

    @Test
    public void testDocPicture() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack").type(APPLICATION_MSWORD).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC_WAV));
        Map data = this.readZipArchive((InputStream)response.getEntity());
        Assertions.assertEquals((Object)"68ead8f4995a3555f48a2f738b2b0c3d", data.get(JPG_NAME));
    }

    @Test
    public void testDocPictureNoOle() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack").type(APPLICATION_MSWORD).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/2pic.doc"));
        Map data = this.readZipArchive((InputStream)response.getEntity());
        Assertions.assertEquals((Object)JPG2_MD5, data.get(JPG2_NAME));
    }

    @Test
    public void testImageDOCX() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack").accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOCX_IMAGE));
        Map data = this.readZipArchive((InputStream)response.getEntity());
        Assertions.assertEquals((Object)DOCX_IMAGE1_MD5, data.get(DOCX_IMAGE1_NAME));
        Assertions.assertEquals((Object)DOCX_IMAGE2_MD5, data.get(DOCX_IMAGE2_NAME));
    }

    @Test
    public void test204() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack").type("xxx/xxx").accept(new String[]{"*/*"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC_WAV));
        Assertions.assertEquals((int)204, (int)response.getStatus());
    }

    @Test
    public void testExeDOCX() throws Exception {
        String TEST_DOCX_EXE = "test-documents/2exe.docx";
        Response response = WebClient.create((String)"http://localhost:9998/unpack").accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOCX_EXE));
        Map data = this.readZipArchive((InputStream)response.getEntity());
        Assertions.assertEquals((Object)DOCX_EXE1_MD5, data.get(DOCX_EXE1_NAME));
        Assertions.assertEquals((Object)DOCX_EXE2_MD5, data.get(DOCX_EXE2_NAME));
    }

    @Test
    public void testImageXSL() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack").accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/pic.xls"));
        Map data = this.readZipArchive((InputStream)response.getEntity());
        Assertions.assertEquals((Object)"68ead8f4995a3555f48a2f738b2b0c3d", data.get("0.jpg"));
        Assertions.assertEquals((Object)XSL_IMAGE2_MD5, data.get("1.jpg"));
    }

    @Test
    public void testTarDocPicture() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack").type(APPLICATION_MSWORD).accept(new String[]{"application/x-tar"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC_WAV));
        Map data = this.readArchiveFromStream((ArchiveInputStream)new TarArchiveInputStream((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"68ead8f4995a3555f48a2f738b2b0c3d", data.get(JPG_NAME));
    }

    @Test
    public void testText() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack/all").header(CONTENT_TYPE, new Object[]{APPLICATION_XML}).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/test.doc"));
        String responseMsg = this.readArchiveMetadataAndText((InputStream)response.getEntity());
        Assertions.assertNotNull((Object)responseMsg);
        UnpackerResourceTest.assertContains((String)"test", (String)responseMsg);
        UnpackerResourceTest.assertContains((String)"dc:creator,Maxim Valyanskiy", (String)responseMsg);
    }

    @Test
    public void testMaxBytes() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack/all").header(CONTENT_TYPE, new Object[]{APPLICATION_XML}).header("unpackMaxBytes", new Object[]{100}).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/pic.xls"));
        Assertions.assertEquals((int)422, (int)response.getStatus());
    }

    @Test
    public void testPDFImages() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack").header("X-Tika-PDFExtractInlineImages", new Object[]{"true"}).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        Map results = this.readZipArchive((InputStream)response.getEntity());
        Assertions.assertTrue((boolean)results.containsKey("image0.png"));
        String md5 = (String)results.get("image0.png");
        Assertions.assertTrue((md5.equals("7c2f14acbb737672a1245f4ceb50622a") || md5.equals("58b8269d1a584b7e8c1adcb936123923") ? 1 : 0) != 0);
    }

    @Test
    public void testPDFRenderOCR() throws Exception {
        Assumptions.assumeTrue((boolean)new TesseractOCRParser().hasTesseract());
        Response response = WebClient.create((String)"http://localhost:9998/unpack/all").header("X-Tika-PDFocrStrategy", new Object[]{"ocr_only"}).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        String txt = this.readArchiveText((InputStream)response.getEntity());
        CXFTestBase.assertContains((String)"Happy New Year", (String)txt);
    }

    @Test
    public void testPDFPerPageRenderColor() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/unpack/all").header("X-Tika-PDFimageStrategy", new Object[]{"RenderPagesAtPageEnd"}).header("X-Tika-PDFocrImageType", new Object[]{"rgb"}).accept(new String[]{"application/zip"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testColorRendering.pdf"));
        Map results = this.readZipArchiveBytes((InputStream)response.getEntity());
        byte[] renderedImage = null;
        for (Map.Entry e : results.entrySet()) {
            if (!((String)e.getKey()).startsWith("tika-pdfbox-rendering")) continue;
            renderedImage = (byte[])e.getValue();
            break;
        }
        Assertions.assertEquals((Object)"image/png", (Object)TikaConfig.getDefaultConfig().getDetector().detect((InputStream)new ByteArrayInputStream(renderedImage), new Metadata()).toString());
        try (ByteArrayInputStream is = new ByteArrayInputStream(renderedImage);){
            BufferedImage image = ImageIO.read(is);
            CXFTestBase.AverageColor averageColor = UnpackerResourceTest.getAverageColor((BufferedImage)image, (int)0, (int)(image.getWidth() / 5), (int)0, (int)(image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() > 250.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() < 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() < 1.0 ? 1 : 0) != 0);
            averageColor = UnpackerResourceTest.getAverageColor((BufferedImage)image, (int)0, (int)(image.getWidth() / 5), (int)(image.getHeight() / 2 + image.getHeight() / 10), (int)(image.getHeight() / 2 + 2 * image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() < 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() > 250.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() < 1.0 ? 1 : 0) != 0);
            averageColor = UnpackerResourceTest.getAverageColor((BufferedImage)image, (int)(image.getWidth() / 2 + image.getWidth() / 10), (int)(image.getWidth() / 2 + 2 * image.getWidth() / 10), (int)(image.getHeight() / 2 + image.getHeight() / 10), (int)(image.getHeight() / 2 + 2 * image.getHeight() / 10));
            Assertions.assertTrue((averageColor.getRed() < 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getGreen() < 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((averageColor.getBlue() > 250.0 ? 1 : 0) != 0);
        }
    }
}

