/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.apache.tika.serialization.JsonMetadata;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaResourceTest
extends CXFTestBase {
    public static final String TEST_DOC = "test-documents/test.doc";
    public static final String TEST_PASSWORD_PROTECTED = "test-documents/password.xls";
    private static final String TEST_RECURSIVE_DOC = "test-documents/test_recursive_embedded.docx";
    private static final String TEST_OOM = "mock/fake_oom.xml";
    private static final String STREAM_CLOSED_FAULT = "java.io.IOException: Stream Closed";
    private static final String TIKA_PATH = "/tika";
    private static final String TIKA_POST_PATH = "/tika/form";
    private static final int UNPROCESSEABLE = 422;

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaResource.class});
        sf.setResourceProvider(TikaResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TikaServerParseExceptionMapper(false));
        providers.add(new JSONMessageBodyWriter());
        sf.setProviders(providers);
    }

    protected InputStream getTikaConfigInputStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/config/tika-config-for-server-tests.xml");
    }

    @Test
    public void testHelloWorld() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("text/plain").accept(new String[]{"text/plain"}).get();
        Assertions.assertEquals((Object)TikaResource.GREETING, (Object)TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity())));
    }

    @Test
    public void testSimpleWord() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/msword").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("test"));
    }

    @Test
    public void testWordGzipIn() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/msword").accept(new String[]{"text/plain"}).encoding("gzip").put((Object)TikaResourceTest.gzip((InputStream)ClassLoader.getSystemResourceAsStream(TEST_DOC)));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("test"));
    }

    @Test
    public void testLongGzipOut() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).acceptEncoding(new String[]{"gzip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        Assertions.assertTrue((boolean)response.getHeaders().containsKey((Object)"Content-Encoding"));
        Assertions.assertEquals((Object)"gzip", (Object)response.getHeaderString("Content-Encoding"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)new GzipCompressorInputStream((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("Course of human"));
    }

    @Test
    public void testShortGzipOut() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).acceptEncoding(new String[]{"gzip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC));
        Assertions.assertFalse((boolean)response.getHeaders().containsKey((Object)"Content-Encoding"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("test"));
    }

    @Test
    public void testTextMain() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika/main").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testHTML.html"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("Title : Test Indexation Html"));
        Assertions.assertFalse((boolean)responseMsg.contains("Indexation du fichier"));
    }

    @Test
    public void testTextMainMultipart() throws Exception {
        Attachment attachmentPart = new Attachment("myhtml", "text/html", (Object)ClassLoader.getSystemResourceAsStream("test-documents/testHTML.html"));
        Response response = WebClient.create((String)"http://localhost:9998/tika/form/main").type("multipart/form-data").accept(new String[]{"text/plain"}).post((Object)attachmentPart);
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("Title : Test Indexation Html"));
        Assertions.assertFalse((boolean)responseMsg.contains("Indexation du fichier"));
    }

    @Test
    public void testPasswordXLS() {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/vnd.ms-excel").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_PASSWORD_PROTECTED));
        Assertions.assertEquals((int)422, (int)response.getStatus());
    }

    @Test
    public void testSimpleWordHTML() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/msword").accept(new String[]{"text/html"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("test"));
        TikaResourceTest.assertContains((String)"<meta name=\"X-TIKA:digest:MD5\" content=\"f8be45c34e8919eedba48cc8d207fbf0\"/>", (String)responseMsg);
        TikaResourceTest.assertContains((String)"<meta name=\"X-TIKA:digest:SHA1\" content=\"N4EBCE7EGTIGZWETEJ6WD3W4KN32TLPG\"/>", (String)responseMsg);
    }

    @Test
    public void testPasswordXLSHTML() {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/vnd.ms-excel").accept(new String[]{"text/html"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_PASSWORD_PROTECTED));
        Assertions.assertEquals((int)422, (int)response.getStatus());
    }

    @Test
    public void testSimpleWordXML() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/msword").accept(new String[]{"text/xml"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_DOC));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("test"));
    }

    @Test
    public void testPasswordXLSXML() {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/vnd.ms-excel").accept(new String[]{"text/xml"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_PASSWORD_PROTECTED));
        Assertions.assertEquals((int)422, (int)response.getStatus());
    }

    @Test
    public void testSimpleWordMultipartXML() throws Exception {
        ClassLoader.getSystemResourceAsStream(TEST_DOC);
        Attachment attachmentPart = new Attachment("myworddoc", "application/msword", (Object)ClassLoader.getSystemResourceAsStream(TEST_DOC));
        WebClient webClient = WebClient.create((String)"http://localhost:9998/tika/form");
        Response response = webClient.type("multipart/form-data").accept(new String[]{"text/xml"}).post((Object)attachmentPart);
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("test"));
        TikaResourceTest.assertContains((String)"<meta name=\"X-TIKA:digest:MD5\" content=\"f8be45c34e8919eedba48cc8d207fbf0\"/>", (String)responseMsg);
    }

    @Test
    public void testJAXBAndActivationDependency() {
        AttachmentUtil.getCommandMap();
    }

    @Test
    public void testEmbedded() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("Course of human events"));
        response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/xml"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("Course of human events"));
        TikaResourceTest.assertContains((String)"<meta name=\"X-TIKA:digest:MD5\" content=\"59f626e09a8c16ab6dbc2800c685f772\"/>", (String)responseMsg);
    }

    @Test
    public void testWMFInRTF() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/rtf").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testRTF_npeFromWMFInTikaServer.rtf"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("Example text"));
    }

    @Test
    public void testOCRLanguageConfig() throws Exception {
        if (!new TesseractOCRParser().hasTesseract()) {
            return;
        }
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).header("X-Tika-PDFOcrStrategy", new Object[]{"ocr_only"}).header("X-Tika-OCRLanguage", new Object[]{"eng+fra"}).header("X-Tika-OCRMinFileSizeToOcr", new Object[]{"10"}).header("X-Tika-OCRMaxFileSizeToOcr", new Object[]{"1000000000"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaResourceTest.assertContains((String)"Happy New Year 2003!", (String)responseMsg);
    }

    @Test
    public void testPDFOCRConfig() throws Exception {
        if (!new TesseractOCRParser().hasTesseract()) {
            return;
        }
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-PDFOcrStrategy", new Object[]{"no_ocr"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"", (Object)responseMsg.trim());
        response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-OCRskipOcr", new Object[]{"true"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"", (Object)responseMsg.trim());
        response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-PDFOcrStrategy", new Object[]{"ocr_only"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaResourceTest.assertContains((String)"Happy New Year 2003!", (String)responseMsg);
        response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-PDFOcrStrategy", new Object[]{"non-sense-value"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        Assertions.assertEquals((int)400, (int)response.getStatus());
    }

    @Test
    public void testPDFLowerCaseOCRConfig() throws Exception {
        if (!new TesseractOCRParser().hasTesseract()) {
            return;
        }
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-PDF".toLowerCase(Locale.ROOT) + "ocrstrategy", new Object[]{"no_ocr"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"", (Object)responseMsg.trim());
        response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-OCR".toLowerCase(Locale.ROOT) + "skipocr", new Object[]{"true"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"", (Object)responseMsg.trim());
        response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-PDF".toLowerCase(Locale.ROOT) + "ocrstrategy", new Object[]{"ocr_only"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaResourceTest.assertContains((String)"Happy New Year 2003!", (String)responseMsg);
        response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-PDF".toLowerCase(Locale.ROOT) + "ocrstrategy", new Object[]{"non-sense-value"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        Assertions.assertEquals((int)400, (int)response.getStatus());
    }

    @Test
    public void testPDFConfig() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testPDFTwoTextBoxes.pdf"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        responseMsg = responseMsg.replaceAll("[\r\n ]+", " ").trim();
        Assertions.assertEquals((Object)"Left column line 1 Right column line 1 Left colu mn line 2 Right column line 2", (Object)responseMsg);
        response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-PDFsortByPosition", new Object[]{"false"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testPDFTwoTextBoxes.pdf"));
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        responseMsg = responseMsg.replaceAll("[\r\n ]+", " ").trim();
        Assertions.assertEquals((Object)"Left column line 1 Left column line 2 Right column line 1 Right column line 2", (Object)responseMsg);
        response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testPDFTwoTextBoxes.pdf"));
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        responseMsg = responseMsg.replaceAll("[\r\n ]+", " ").trim();
        Assertions.assertEquals((Object)"Left column line 1 Right column line 1 Left colu mn line 2 Right column line 2", (Object)responseMsg);
    }

    @Test
    public void testExtractTextAcceptPlainText() throws Exception {
        Attachment attachmentPart = new Attachment("my-docx-file", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)ClassLoader.getSystemResourceAsStream("test-documents/2pic.docx"));
        Response response = WebClient.create((String)"http://localhost:9998/tika/form").type("multipart/form-data").accept(new String[]{"text/plain"}).post((Object)attachmentPart);
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertTrue((boolean)responseMsg.contains("P1040893.JPG"));
        TikaResourceTest.assertNotFound((String)STREAM_CLOSED_FAULT, (String)responseMsg);
    }

    @Test
    public void testDataIntegrityCheck() {
        Response response;
        try {
            response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-OCRtesseractPath", new Object[]{"C://tmp//hello.bat\u0000"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
            Assertions.assertEquals((int)400, (int)response.getStatus());
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        try {
            response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-OCRtesseractPath", new Object[]{"bogus path"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
            Assertions.assertEquals((int)400, (int)response.getStatus());
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    @Test
    public void testTrustedMethodPrevention() {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-OCRtrustedPageSeparator", new Object[]{" "}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        Assertions.assertEquals((int)400, (int)response.getStatus());
    }

    @Test
    public void testFloatInHeader() {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("application/pdf").accept(new String[]{"text/plain"}).header("X-Tika-PDFaverageCharTolerance", new Object[]{"2.0"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"));
        Assertions.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testUnicodePasswordProtectedSpaces() throws Exception {
        String password = "    ";
        String encoded = new Base64().encodeAsString("    ".getBytes(StandardCharsets.UTF_8));
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).header("Password_Base64_UTF-8", new Object[]{encoded}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testPassword4Spaces.pdf"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaResourceTest.assertContains((String)"Just some text.", (String)responseMsg);
    }

    @Test
    public void testUnicodePasswordProtectedUnicode() throws Exception {
        String password = "  ! < > \" \\ \u20ac \u0153 \u00a4 1\u20444 1\u20442 \ud841\udf0e \ud867\udd98 \ud83d\ude00  ";
        String encoded = new Base64().encodeAsString("  ! < > \" \\ \u20ac \u0153 \u00a4 1\u20444 1\u20442 \ud841\udf0e \ud867\udd98 \ud83d\ude00  ".getBytes(StandardCharsets.UTF_8));
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).header("Password_Base64_UTF-8", new Object[]{encoded}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testUnicodePassword.pdf"));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaResourceTest.assertContains((String)"Just some text.", (String)responseMsg);
    }

    @Test
    public void testSkipEmbedded() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).header("X-Tika-Skip-Embedded", new Object[]{"false"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaResourceTest.assertContains((String)"embed4.txt", (String)responseMsg);
        response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).header("X-Tika-Skip-Embedded", new Object[]{"true"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaResourceTest.assertNotFound((String)"embed4.txt", (String)responseMsg);
    }

    @Test
    public void testPDFLowerCaseOCRConfigPOST() throws Exception {
        if (!new TesseractOCRParser().hasTesseract()) {
            return;
        }
        Response response = WebClient.create((String)"http://localhost:9998/tika/form").type("application/pdf").accept(new String[]{"text/plain"}).type("multipart/form-data").header("X-Tika-PDF".toLowerCase(Locale.ROOT) + "ocrstrategy", new Object[]{"no_ocr"}).post((Object)this.testPDFLowerCaseOCRConfigPOSTBody());
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"", (Object)responseMsg.trim());
        response = WebClient.create((String)"http://localhost:9998/tika/form").type("application/pdf").accept(new String[]{"text/plain"}).type("multipart/form-data").header("X-Tika-PDF".toLowerCase(Locale.ROOT) + "ocrstrategy", new Object[]{"ocr_only"}).post((Object)this.testPDFLowerCaseOCRConfigPOSTBody());
        responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaResourceTest.assertContains((String)"Happy New Year 2003!", (String)responseMsg);
        response = WebClient.create((String)"http://localhost:9998/tika/form").type("application/pdf").accept(new String[]{"text/plain"}).type("multipart/form-data").header("X-Tika-PDF".toLowerCase(Locale.ROOT) + "ocrstrategy", new Object[]{"non-sense-value"}).post((Object)this.testPDFLowerCaseOCRConfigPOSTBody());
        Assertions.assertEquals((int)400, (int)response.getStatus());
    }

    private MultipartBody testPDFLowerCaseOCRConfigPOSTBody() {
        ContentDisposition cd = new ContentDisposition("form-data; name=\"input\"; filename=\"testOCR.pdf\"");
        Attachment att = new Attachment("upload", ClassLoader.getSystemResourceAsStream("test-documents/testOCR.pdf"), cd);
        return new MultipartBody(att);
    }

    @Test
    public void testJson() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika/text").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        TikaResourceTest.assertContains((String)"embed4.txt", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaResourceTest.assertContains((String)"General Congress", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaResourceTest.assertNotFound((String)"<p", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)metadata.get(OfficeOpenXMLExtended.APPLICATION));
        TikaTest.assertContains((Object)"org.apache.tika.parser.microsoft.EMFParser", Arrays.asList(metadata.getValues(TikaCoreProperties.TIKA_PARSED_BY_FULL_SET)));
    }

    @Test
    public void testJsonWriteLimitEmbedded() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika/html").accept(new String[]{"application/json"}).header("writeLimit", new Object[]{"500"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        TikaResourceTest.assertContains((String)"embed2a.txt", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaResourceTest.assertContains((String)"When in the Course", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaResourceTest.assertNotFound((String)"declare the causes", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)metadata.get(OfficeOpenXMLExtended.APPLICATION));
        Assertions.assertTrue((boolean)metadata.get(TikaCoreProperties.CONTAINER_EXCEPTION).startsWith("org.apache.tika.exception.WriteLimitReachedException"));
        TikaResourceTest.assertNotFound((String)"embed4.txt", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testJsonNoThrowWriteLimitEmbedded() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika/html").accept(new String[]{"application/json"}).header("writeLimit", new Object[]{"500"}).header("throwOnWriteLimitReached", new Object[]{"false"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        String txt = metadata.get(TikaCoreProperties.TIKA_CONTENT);
        TikaResourceTest.assertContains((String)"embed2a.txt", (String)txt);
        TikaResourceTest.assertContains((String)"When in the Course", (String)txt);
        TikaResourceTest.assertNotFound((String)"declare the causes", (String)txt);
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)metadata.get(OfficeOpenXMLExtended.APPLICATION));
        Assertions.assertEquals((Object)"true", (Object)metadata.get(TikaCoreProperties.WRITE_LIMIT_REACHED));
        TikaResourceTest.assertContains((String)"<div class=\"embedded\" id=\"embed4.txt", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testWriteLimitInPDF() throws Exception {
        int writeLimit = 10;
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"application/json"}).header("writeLimit", new Object[]{Integer.toString(writeLimit)}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testPDFTwoTextBoxes.pdf"));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        Metadata metadata = JsonMetadata.fromJson((Reader)reader);
        Assertions.assertEquals((Object)"true", (Object)metadata.get(TikaCoreProperties.WRITE_LIMIT_REACHED));
    }
}

