/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.pkg.PackageParser;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.TikaParsers;
import org.gagravarr.tika.OpusParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaParsersTest
extends CXFTestBase {
    private static final String PARSERS_SUMMARY_PATH = "/parsers";
    private static final String PARSERS_DETAILS_PATH = "/parsers/details";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaParsers.class});
        sf.setResourceProvider(TikaParsers.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaParsers()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
    }

    protected InputStream getTikaConfigInputStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/config/tika-config-for-server-tests.xml");
    }

    protected String getPath(boolean withDetails) {
        return withDetails ? PARSERS_DETAILS_PATH : PARSERS_SUMMARY_PATH;
    }

    @Test
    public void testGetPlainText() throws Exception {
        for (boolean details : new boolean[]{false, true}) {
            Response response = WebClient.create((String)("http://localhost:9998" + this.getPath(details))).type("text/plain").accept(new String[]{"text/plain"}).get();
            String text = TikaParsersTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
            TikaParsersTest.assertContains((String)"org.apache.tika.parser.DefaultParser (Composite Parser)", (String)text);
            TikaParsersTest.assertContains((String)OpusParser.class.getName(), (String)text);
            TikaParsersTest.assertContains((String)PackageParser.class.getName(), (String)text);
            TikaParsersTest.assertContains((String)OOXMLParser.class.getName(), (String)text);
            if (details) {
                TikaParsersTest.assertContains((String)"text/plain", (String)text);
                TikaParsersTest.assertContains((String)"application/pdf", (String)text);
                TikaParsersTest.assertContains((String)"audio/ogg", (String)text);
                continue;
            }
            TikaParsersTest.assertNotFound((String)"text/plain", (String)text);
            TikaParsersTest.assertNotFound((String)"application/pdf", (String)text);
            TikaParsersTest.assertNotFound((String)"audio/ogg", (String)text);
        }
    }

    @Test
    public void testGetHTML() throws Exception {
        for (boolean details : new boolean[]{false, true}) {
            Response response = WebClient.create((String)("http://localhost:9998" + this.getPath(details))).type("text/html").accept(new String[]{"text/html"}).get();
            String text = TikaParsersTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
            TikaParsersTest.assertContains((String)"<h3>DefaultParser</h3>", (String)text);
            TikaParsersTest.assertContains((String)"Composite", (String)text);
            TikaParsersTest.assertContains((String)"<h4>OpusParser", (String)text);
            TikaParsersTest.assertContains((String)"<h4>PackageParser", (String)text);
            TikaParsersTest.assertContains((String)"<h4>OOXMLParser", (String)text);
            TikaParsersTest.assertContains((String)OpusParser.class.getName(), (String)text);
            TikaParsersTest.assertContains((String)PackageParser.class.getName(), (String)text);
            TikaParsersTest.assertContains((String)OOXMLParser.class.getName(), (String)text);
            if (details) {
                TikaParsersTest.assertContains((String)"<li>text/plain", (String)text);
                TikaParsersTest.assertContains((String)"<li>application/pdf", (String)text);
                TikaParsersTest.assertContains((String)"<li>audio/ogg", (String)text);
                continue;
            }
            TikaParsersTest.assertNotFound((String)"text/plain", (String)text);
            TikaParsersTest.assertNotFound((String)"application/pdf", (String)text);
            TikaParsersTest.assertNotFound((String)"audio/ogg", (String)text);
        }
    }

    @Test
    public void testGetJSON() throws Exception {
        for (boolean details : new boolean[]{false, true}) {
            Response response = WebClient.create((String)("http://localhost:9998" + this.getPath(details))).type("application/json").accept(new String[]{"application/json"}).get();
            String jsonStr = TikaParsersTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
            Map json = (Map)new ObjectMapper().readerFor(Map.class).readValue(jsonStr);
            Assertions.assertEquals((Object)true, (Object)json.containsKey("name"));
            Assertions.assertEquals((Object)true, (Object)json.containsKey("composite"));
            Assertions.assertEquals((Object)true, (Object)json.containsKey("children"));
            Assertions.assertEquals((Object)"org.apache.tika.parser.CompositeParser", json.get("name"));
            Assertions.assertEquals((Object)Boolean.TRUE, json.get("composite"));
            List children = (List)json.get("children");
            Assertions.assertTrue((children.size() >= 2 ? 1 : 0) != 0);
            boolean hasOpus = false;
            boolean hasOOXML = false;
            boolean hasZip = false;
            int nonComposite = 0;
            int composite = 0;
            for (Object o : children) {
                Map child = (Map)o;
                Assertions.assertEquals((Object)true, (Object)child.containsKey("name"));
                Assertions.assertEquals((Object)true, (Object)child.containsKey("composite"));
                List grandChildrenArr = (List)child.get("children");
                if (grandChildrenArr == null) continue;
                Assertions.assertTrue((grandChildrenArr.size() > 50 ? 1 : 0) != 0);
                for (Object grandChildO : grandChildrenArr) {
                    Map grandChildren = (Map)grandChildO;
                    if (grandChildren.get("composite") == Boolean.FALSE) {
                        ++nonComposite;
                    } else {
                        ++composite;
                    }
                    if (grandChildren.get("composite") == Boolean.FALSE) {
                        Assertions.assertEquals((Object)details, (Object)grandChildren.containsKey("supportedTypes"));
                    }
                    String name = (String)grandChildren.get("name");
                    if (OpusParser.class.getName().equals(name)) {
                        hasOpus = true;
                    }
                    if (OOXMLParser.class.getName().equals(name)) {
                        hasOOXML = true;
                    }
                    if (!PackageParser.class.getName().equals(name)) continue;
                    hasZip = true;
                }
            }
            Assertions.assertEquals((Object)true, (Object)hasOpus);
            Assertions.assertEquals((Object)true, (Object)hasOOXML);
            Assertions.assertEquals((Object)true, (Object)hasZip);
            Assertions.assertTrue((nonComposite > 20 ? 1 : 0) != 0);
            Assertions.assertTrue((composite == 0 || composite == 1 ? 1 : 0) != 0);
        }
    }
}

