/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.TikaMimeTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaMimeTypesTest
extends CXFTestBase {
    private static final String MIMETYPES_PATH = "/mime-types";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaMimeTypes.class});
        sf.setResourceProvider(TikaMimeTypes.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaMimeTypes()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
    }

    @Test
    public void testGetJSON() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/mime-types").type("application/json").accept(new String[]{"application/json"}).get();
        String jsonStr = TikaMimeTypesTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Map json = (Map)new ObjectMapper().readerFor(Map.class).readValue(jsonStr);
        Assertions.assertEquals((Object)true, (Object)json.containsKey("text/plain"));
        Assertions.assertEquals((Object)true, (Object)json.containsKey("application/xml"));
        Assertions.assertEquals((Object)true, (Object)json.containsKey("video/x-ogm"));
        Assertions.assertEquals((Object)true, (Object)json.containsKey("image/bmp"));
        Map bmp = (Map)json.get("image/bmp");
        Assertions.assertEquals((Object)true, (Object)bmp.containsKey("alias"));
        List aliases = (List)bmp.get("alias");
        Assertions.assertEquals((int)2, (int)aliases.size());
        Assertions.assertEquals((Object)"image/x-bmp", aliases.get(0));
        Assertions.assertEquals((Object)"image/x-ms-bmp", aliases.get(1));
        String whichParser = bmp.get("parser").toString();
        Assertions.assertTrue((whichParser.equals("org.apache.tika.parser.ocr.TesseractOCRParser") || whichParser.equals("org.apache.tika.parser.image.ImageParser") ? 1 : 0) != 0, (String)"Which parser");
        Map ogm = (Map)json.get("video/x-ogm");
        Assertions.assertEquals((Object)"video/ogg", ogm.get("supertype"));
        Assertions.assertEquals((Object)"org.gagravarr.tika.OggParser", ogm.get("parser"));
    }
}

