/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.detect.microsoft.POIFSContainerDetector;
import org.apache.tika.detect.zip.DefaultZipContainerDetector;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.TikaDetectors;
import org.gagravarr.tika.OggDetector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaDetectorsTest
extends CXFTestBase {
    private static final String DETECTORS_PATH = "/detectors";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaDetectors.class});
        sf.setResourceProvider(TikaDetectors.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaDetectors()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
    }

    @Test
    public void testGetPlainText() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/detectors").type("text/plain").accept(new String[]{"text/plain"}).get();
        String text = TikaDetectorsTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaDetectorsTest.assertContains((String)"org.apache.tika.detect.DefaultDetector (Composite Detector)", (String)text);
        TikaDetectorsTest.assertContains((String)OggDetector.class.getName(), (String)text);
        TikaDetectorsTest.assertContains((String)POIFSContainerDetector.class.getName(), (String)text);
        TikaDetectorsTest.assertContains((String)DefaultZipContainerDetector.class.getName(), (String)text);
        TikaDetectorsTest.assertContains((String)MimeTypes.class.getName(), (String)text);
    }

    @Test
    public void testGetHTML() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/detectors").type("text/html").accept(new String[]{"text/html"}).get();
        String text = TikaDetectorsTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        TikaDetectorsTest.assertContains((String)"<h2>DefaultDetector</h2>", (String)text);
        TikaDetectorsTest.assertContains((String)"Composite", (String)text);
        TikaDetectorsTest.assertContains((String)"<h3>OggDetector", (String)text);
        TikaDetectorsTest.assertContains((String)"<h3>POIFSContainerDetector", (String)text);
        TikaDetectorsTest.assertContains((String)"<h3>MimeTypes", (String)text);
        TikaDetectorsTest.assertContains((String)OggDetector.class.getName(), (String)text);
        TikaDetectorsTest.assertContains((String)POIFSContainerDetector.class.getName(), (String)text);
        TikaDetectorsTest.assertContains((String)DefaultZipContainerDetector.class.getName(), (String)text);
        TikaDetectorsTest.assertContains((String)MimeTypes.class.getName(), (String)text);
    }

    @Test
    public void testGetJSON() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/detectors").type("application/json").accept(new String[]{"application/json"}).get();
        String jsonStr = TikaDetectorsTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Map json = (Map)new ObjectMapper().readerFor(Map.class).readValue(jsonStr);
        Assertions.assertTrue((boolean)json.containsKey("name"));
        Assertions.assertTrue((boolean)json.containsKey("composite"));
        Assertions.assertTrue((boolean)json.containsKey("children"));
        Assertions.assertEquals((Object)"org.apache.tika.detect.DefaultDetector", json.get("name"));
        Assertions.assertEquals((Object)Boolean.TRUE, json.get("composite"));
        List children = (List)json.get("children");
        Assertions.assertTrue((children.size() >= 4 ? 1 : 0) != 0);
        boolean hasOgg = false;
        boolean hasPOIFS = false;
        boolean hasZIP = false;
        boolean hasMime = false;
        for (Object o : children) {
            Map d = (Map)o;
            Assertions.assertTrue((boolean)d.containsKey("name"));
            Assertions.assertTrue((boolean)d.containsKey("composite"));
            Assertions.assertEquals((Object)Boolean.FALSE, d.get("composite"));
            Assertions.assertEquals((Object)false, (Object)d.containsKey("children"));
            String name = (String)d.get("name");
            if (OggDetector.class.getName().equals(name)) {
                hasOgg = true;
            }
            if (POIFSContainerDetector.class.getName().equals(name)) {
                hasPOIFS = true;
            }
            if (DefaultZipContainerDetector.class.getName().equals(name)) {
                hasZIP = true;
            }
            if (!MimeTypes.class.getName().equals(name)) continue;
            hasMime = true;
        }
        Assertions.assertTrue((boolean)hasOgg);
        Assertions.assertTrue((boolean)hasPOIFS);
        Assertions.assertTrue((boolean)hasZIP);
        Assertions.assertTrue((boolean)hasMime);
    }
}

