/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.RecursiveMetadataResource;
import org.apache.tika.server.core.writer.MetadataListMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecursiveMetadataResourceTest
extends CXFTestBase {
    private static final String FORM_PATH = "/form";
    private static final String META_PATH = "/rmeta";
    private static final String TEXT_PATH = "/text";
    private static final String IGNORE_PATH = "/ignore";
    private static final String XML_PATH = "/xml";
    private static final String UNPARSEABLE_PATH = "/somethingOrOther";
    private static final String SLASH = "/";
    private static final String TEST_RECURSIVE_DOC = "test-documents/test_recursive_embedded.docx";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{RecursiveMetadataResource.class});
        sf.setResourceProvider(RecursiveMetadataResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new RecursiveMetadataResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<MetadataListMessageBodyWriter> providers = new ArrayList<MetadataListMessageBodyWriter>();
        providers.add(new MetadataListMessageBodyWriter());
        sf.setProviders(providers);
    }

    protected InputStream getTikaConfigInputStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/config/tika-config-for-server-tests.xml");
    }

    @Test
    public void testGZOut() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).acceptEncoding(new String[]{"gzip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        InputStreamReader reader = new InputStreamReader((InputStream)new GzipCompressorInputStream((InputStream)response.getEntity()), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)((Metadata)metadataList.get(0)).get(OfficeOpenXMLExtended.APPLICATION));
        RecursiveMetadataResourceTest.assertContains((String)"plundered our seas", (String)((Metadata)metadataList.get(6)).get("X-TIKA:content"));
        Assertions.assertEquals((Object)"a38e6c7b38541af87148dee9634cb811", (Object)((Metadata)metadataList.get(10)).get("X-TIKA:digest:MD5"));
    }

    @Test
    public void testGZIn() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).encoding("gzip").put((Object)RecursiveMetadataResourceTest.gzip((InputStream)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC)));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        String[] parsedBy = ((Metadata)metadataList.get(0)).getValues(TikaCoreProperties.TIKA_PARSED_BY);
        Assertions.assertEquals((int)3, (int)parsedBy.length);
        Assertions.assertEquals((Object)"org.apache.tika.parser.CompositeParser", (Object)parsedBy[0]);
        Assertions.assertEquals((Object)"org.apache.tika.parser.DefaultParser", (Object)parsedBy[1]);
        Assertions.assertEquals((Object)"org.apache.tika.parser.microsoft.ooxml.OOXMLParser", (Object)parsedBy[2]);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)((Metadata)metadataList.get(0)).get(OfficeOpenXMLExtended.APPLICATION));
        RecursiveMetadataResourceTest.assertContains((String)"plundered our seas", (String)((Metadata)metadataList.get(6)).get("X-TIKA:content"));
        Assertions.assertEquals((Object)"a38e6c7b38541af87148dee9634cb811", (Object)((Metadata)metadataList.get(10)).get("X-TIKA:digest:MD5"));
    }

    @Test
    public void testSimpleWord() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)((Metadata)metadataList.get(0)).get(OfficeOpenXMLExtended.APPLICATION));
        RecursiveMetadataResourceTest.assertContains((String)"plundered our seas", (String)((Metadata)metadataList.get(6)).get("X-TIKA:content"));
        Assertions.assertEquals((Object)"a38e6c7b38541af87148dee9634cb811", (Object)((Metadata)metadataList.get(10)).get("X-TIKA:digest:MD5"));
    }

    @Test
    public void testHeaders() throws Exception {
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.addAll((Object)"meta_mymeta", (Object[])new String[]{"first", "second", "third"});
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").headers((MultivaluedMap)map).accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((Object)"first,second,third", (Object)((Metadata)metadataList.get(0)).get("mymeta"));
    }

    @Test
    public void testPasswordProtected() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").type("application/vnd.ms-excel").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/password.xls"));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertNotNull((Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CREATOR));
        RecursiveMetadataResourceTest.assertContains((String)"org.apache.tika.exception.EncryptedDocumentException", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CONTAINER_EXCEPTION));
        response = WebClient.create((String)"http://localhost:9998/rmeta").type("application/vnd.ms-excel").accept(new String[]{"application/json"}).header("Password", new Object[]{"password"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/password.xls"));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertNotNull((Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"pavel", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CREATOR));
    }

    @Test
    public void testHandlerType() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        String content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        response = WebClient.create((String)"http://localhost:9998/rmeta/").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        response = WebClient.create((String)"http://localhost:9998/rmeta/somethingOrOther").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        response = WebClient.create((String)"http://localhost:9998/rmeta/xml").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        response = WebClient.create((String)"http://localhost:9998/rmeta/text").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("embed_3"));
        response = WebClient.create((String)"http://localhost:9998/rmeta/ignore").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        Assertions.assertNull((Object)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testHandlerTypeInMultipartXML() throws Exception {
        Attachment attachmentPart = new Attachment("myworddocx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        WebClient webClient = WebClient.create((String)"http://localhost:9998/rmeta/form");
        Response response = webClient.type("multipart/form-data").accept(new String[]{"application/json"}).post((Object)attachmentPart);
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        String content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        attachmentPart = new Attachment("myworddocx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        webClient = WebClient.create((String)"http://localhost:9998/rmeta/form/somethingOrOther");
        response = webClient.type("multipart/form-data").accept(new String[]{"application/json"}).post((Object)attachmentPart);
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        attachmentPart = new Attachment("myworddocx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        webClient = WebClient.create((String)"http://localhost:9998/rmeta/form/xml");
        response = webClient.type("multipart/form-data").accept(new String[]{"application/json"}).post((Object)attachmentPart);
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        attachmentPart = new Attachment("myworddocx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        webClient = WebClient.create((String)"http://localhost:9998/rmeta/form/text");
        response = webClient.type("multipart/form-data").accept(new String[]{"application/json"}).post((Object)attachmentPart);
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        content = ((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).trim();
        Assertions.assertTrue((boolean)content.startsWith("embed_3"));
        attachmentPart = new Attachment("myworddocx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        webClient = WebClient.create((String)"http://localhost:9998/rmeta/form/ignore");
        response = webClient.type("multipart/form-data").accept(new String[]{"application/json"}).query("handler", new Object[]{"ignore"}).post((Object)attachmentPart);
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        Assertions.assertNull((Object)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testEmbeddedResourceLimit() throws Exception {
        for (int i : new int[]{0, 1, 5}) {
            Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).header("maxEmbeddedResources", new Object[]{Integer.toString(i)}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
            Assertions.assertEquals((int)200, (int)response.getStatus());
            InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assertions.assertEquals((int)(i + 1), (int)metadataList.size());
        }
    }

    @Test
    public void testSkipEmbedded() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).header("X-Tika-Skip-Embedded", new Object[]{"false"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).header("X-Tika-Skip-Embedded", new Object[]{"true"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)1, (int)metadataList.size());
    }

    @Test
    public void testWriteLimit() throws Exception {
        int writeLimit = 10;
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).header("writeLimit", new Object[]{Integer.toString(writeLimit)}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Assertions.assertEquals((Object)"true", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.WRITE_LIMIT_REACHED));
        writeLimit = 550;
        response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).header("writeLimit", new Object[]{Integer.toString(writeLimit)}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)10, (int)metadataList.size());
        Assertions.assertEquals((Object)"true", (Object)((Metadata)metadataList.get(6)).get(TikaCoreProperties.WRITE_LIMIT_REACHED));
        RecursiveMetadataResourceTest.assertContains((String)"When in the Course of human events it becomes necessary for one people", (String)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT));
        TikaTest.assertNotContained((String)"We hold these truths", (String)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testWriteLimitInPDF() throws Exception {
        int writeLimit = 10;
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).header("writeLimit", new Object[]{Integer.toString(writeLimit)}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testPDFTwoTextBoxes.pdf"));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Metadata metadata = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"true", (Object)metadata.get(TikaCoreProperties.WRITE_LIMIT_REACHED));
    }

    @Test
    public void testXFA() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testPDF_XFA_govdocs1_258578.pdf"));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Metadata m = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"true", (Object)m.get(PDF.HAS_XFA));
        Assertions.assertTrue((boolean)m.get(TikaCoreProperties.TIKA_CONTENT).contains("Young Abraham Lincoln"));
    }

    @Test
    public void testNoThrowOnWriteLimitReached() throws Exception {
        int writeLimit = 100;
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).header("writeLimit", new Object[]{Integer.toString(writeLimit)}).header("throwOnWriteLimitReached", new Object[]{"false"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        Assertions.assertEquals((Object)"true", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.WRITE_LIMIT_REACHED));
        writeLimit = 550;
        response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).header("writeLimit", new Object[]{Integer.toString(writeLimit)}).header("throwOnWriteLimitReached", new Object[]{"false"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        Assertions.assertEquals((Object)"true", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.WRITE_LIMIT_REACHED));
        RecursiveMetadataResourceTest.assertContains((String)"When in the Course of human events it becomes necessary for one people", (String)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT));
        TikaTest.assertNotContained((String)"We hold these truths", (String)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT));
    }
}

