/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.RecursiveMetadataResource;
import org.apache.tika.server.core.writer.MetadataListMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecursiveMetadataFilterTest
extends CXFTestBase {
    private static final String META_PATH = "/rmeta";
    private static final String TEST_RECURSIVE_DOC = "test-documents/test_recursive_embedded.docx";

    protected InputStream getTikaConfigInputStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/config/TIKA-3137-include.xml");
    }

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{RecursiveMetadataResource.class});
        sf.setResourceProvider(RecursiveMetadataResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new RecursiveMetadataResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<MetadataListMessageBodyWriter> providers = new ArrayList<MetadataListMessageBodyWriter>();
        providers.add(new MetadataListMessageBodyWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testBasicFilter() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).acceptEncoding(new String[]{"gzip"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        InputStreamReader reader = new InputStreamReader((InputStream)new GzipCompressorInputStream((InputStream)response.getEntity()), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)5, (int)metadataList.size());
        HashSet<String> expectedKeys = new HashSet<String>();
        expectedKeys.add("X-TIKA:content");
        expectedKeys.add("extended-properties:Application");
        expectedKeys.add("Content-Type");
        for (Metadata m : metadataList) {
            if (m.get("Content-Type").equals("image/emf")) {
                Assertions.fail((String)"emf should have been filtered out");
            }
            if (m.get("Content-Type").startsWith("text/plain")) {
                Assertions.fail((String)"text/plain should have been filtered out");
            }
            Assertions.assertTrue((m.names().length >= 2 ? 1 : 0) != 0);
            for (String n : m.names()) {
                if (expectedKeys.contains(n)) continue;
                Assertions.fail((String)("didn't expect " + n));
            }
        }
    }
}

