/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadata;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.RecursiveMetadataResource;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.apache.tika.server.core.writer.MetadataListMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenNLPMetadataFilterTest
extends CXFTestBase {
    private static final String TIKA_PATH = "/tika";
    private static final String META_PATH = "/rmeta";
    private static final String TEST_RECURSIVE_DOC = "test-documents/test_recursive_embedded.docx";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{RecursiveMetadataResource.class, TikaResource.class});
        sf.setResourceProvider(RecursiveMetadataResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new RecursiveMetadataResource()));
        sf.setResourceProvider(TikaResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new MetadataListMessageBodyWriter());
        providers.add(new JSONMessageBodyWriter());
        sf.setProviders(providers);
    }

    protected InputStream getTikaConfigInputStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/config/tika-config-langdetect-opennlp-filter.xml");
    }

    @Test
    public void testMeta() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)12, (int)metadataList.size());
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)((Metadata)metadataList.get(0)).get(OfficeOpenXMLExtended.APPLICATION));
        OpenNLPMetadataFilterTest.assertContains((String)"plundered our seas", (String)((Metadata)metadataList.get(6)).get("X-TIKA:content"));
        Assertions.assertEquals((Object)"a38e6c7b38541af87148dee9634cb811", (Object)((Metadata)metadataList.get(10)).get("X-TIKA:digest:MD5"));
        Assertions.assertEquals((Object)"eng", (Object)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_DETECTED_LANGUAGE));
        Assertions.assertEquals((Object)"LOW", (Object)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_DETECTED_LANGUAGE_CONFIDENCE));
    }

    @Test
    public void testTika() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_RECURSIVE_DOC));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        Metadata metadata = JsonMetadata.fromJson((Reader)reader);
        Assertions.assertEquals((Object)"eng", (Object)metadata.get(TikaCoreProperties.TIKA_DETECTED_LANGUAGE));
        Assertions.assertEquals((Object)"LOW", (Object)metadata.get(TikaCoreProperties.TIKA_DETECTED_LANGUAGE_CONFIDENCE));
    }
}

