/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadata;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.MetadataResource;
import org.apache.tika.server.core.writer.CSVMessageBodyWriter;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.apache.tika.server.core.writer.TextMessageBodyWriter;
import org.apache.tika.server.standard.resource.XMPMetadataResource;
import org.apache.tika.server.standard.writer.XMPMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataResourceTest
extends CXFTestBase {
    private static final String META_PATH = "/meta";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{MetadataResource.class, XMPMetadataResource.class});
        sf.setResourceProvider(MetadataResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new MetadataResource()));
        sf.setResourceProvider(XMPMetadataResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new XMPMetadataResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new JSONMessageBodyWriter());
        providers.add(new CSVMessageBodyWriter());
        providers.add(new XMPMessageBodyWriter());
        providers.add(new TextMessageBodyWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testSimpleWord() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/meta").type("application/msword").accept(new String[]{"text/csv"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/test.doc"));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        CSVParser csvReader = ((CSVParser.Builder)CSVParser.builder().setReader((Reader)reader)).setFormat(CSVFormat.EXCEL).get();
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (CSVRecord r : csvReader) {
            metadata.put(r.get(0), r.get(1));
        }
        csvReader.close();
        Assertions.assertNotNull(metadata.get(TikaCoreProperties.CREATOR.getName()));
        Assertions.assertEquals((Object)"Maxim Valyanskiy", metadata.get(TikaCoreProperties.CREATOR.getName()));
        Assertions.assertEquals((Object)"f8be45c34e8919eedba48cc8d207fbf0", metadata.get("X-TIKA:digest:MD5"), (String)"X-TIKA:digest:MD5");
    }

    @Test
    public void testPasswordProtected() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/meta").type("application/vnd.ms-excel").accept(new String[]{"text/csv"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/password.xls"));
        Assertions.assertEquals((int)500, (int)response.getStatus());
        response = WebClient.create((String)"http://localhost:9998/meta").type("application/vnd.ms-excel").accept(new String[]{"text/csv"}).header("Password", new Object[]{"wrong password"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/password.xls"));
        Assertions.assertEquals((int)500, (int)response.getStatus());
        response = WebClient.create((String)"http://localhost:9998/meta").type("application/vnd.ms-excel").accept(new String[]{"text/csv"}).header("Password", new Object[]{"password"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/password.xls"));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        HashMap<String, String> metadata = new HashMap<String, String>();
        try (InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
             CSVParser csvReader = ((CSVParser.Builder)CSVParser.builder().setReader((Reader)reader)).setFormat(CSVFormat.EXCEL).get();){
            for (CSVRecord r : csvReader) {
                metadata.put(r.get(0), r.get(1));
            }
        }
        Assertions.assertNotNull(metadata.get(TikaCoreProperties.CREATOR.getName()));
        Assertions.assertEquals((Object)"pavel", metadata.get(TikaCoreProperties.CREATOR.getName()));
    }

    @Test
    public void testJSON() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/meta").type("application/msword").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/test.doc"));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        Metadata metadata = JsonMetadata.fromJson((Reader)reader);
        Assertions.assertNotNull((Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Maxim Valyanskiy", (Object)metadata.get(TikaCoreProperties.CREATOR));
    }

    @Test
    public void testXMP() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/meta").type("application/msword").accept(new String[]{"application/rdf+xml"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/test.doc"));
        String result = IOUtils.readStringFromStream((InputStream)((InputStream)response.getEntity()));
        MetadataResourceTest.assertContains((String)"<rdf:li>Maxim Valyanskiy</rdf:li>", (String)result);
    }

    @Test
    public void testGetField_XXX_NotFound() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/meta/xxx").type("application/msword").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/test.doc"));
        Assertions.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatus());
    }

    @Test
    public void testGetField_Author_TEXT_Partial_BAD_REQUEST() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("test-documents/test.doc");
        Response response = WebClient.create((String)"http://localhost:9998/meta/Author").type("application/msword").accept(new String[]{"text/plain"}).put((Object)MetadataResourceTest.copy((InputStream)stream, (int)8000));
        Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
    }

    @Test
    public void testGetField_Author_TEXT_Partial_Found() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("test-documents/test.doc");
        Response response = WebClient.create((String)("http://localhost:9998/meta/" + TikaCoreProperties.CREATOR.getName())).type("application/msword").accept(new String[]{"text/plain"}).put((Object)MetadataResourceTest.copy((InputStream)stream, (int)12000));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String s = IOUtils.readStringFromStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"Maxim Valyanskiy", (Object)s);
    }

    @Test
    public void testGetField_Author_JSON_Partial_Found() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("test-documents/test.doc");
        Response response = WebClient.create((String)("http://localhost:9998/meta/" + TikaCoreProperties.CREATOR.getName())).type("application/msword").accept(new String[]{"application/json"}).put((Object)MetadataResourceTest.copy((InputStream)stream, (int)12000));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"Maxim Valyanskiy", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((int)1, (int)metadata.names().length);
    }

    @Test
    public void testGetField_Author_XMP_Partial_Found() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("test-documents/test.doc");
        Response response = WebClient.create((String)"http://localhost:9998/meta/dc:creator").type("application/msword").accept(new String[]{"application/rdf+xml"}).put((Object)MetadataResourceTest.copy((InputStream)stream, (int)12000));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String s = IOUtils.readStringFromStream((InputStream)((InputStream)response.getEntity()));
        MetadataResourceTest.assertContains((String)"<rdf:li>Maxim Valyanskiy</rdf:li>", (String)s);
    }
}

