/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadata;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class JsonMaxFieldLengthTest
extends CXFTestBase {
    private static final String TIKA_PATH = "/tika";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaResource.class});
        sf.setResourceProvider(TikaResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TikaServerParseExceptionMapper(false));
        providers.add(new JSONMessageBodyWriter());
        sf.setProviders(providers);
    }

    protected InputStream getTikaConfigInputStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/config/tika-config-json.xml");
    }

    @Test
    public void testLargeJson(@TempDir Path dir) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 30000000; ++i) {
            sb.append("v");
        }
        Path tmp = Files.createTempFile(dir, "long-json-", ".txt", new FileAttribute[0]);
        Files.write(tmp, sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Response response = WebClient.create((String)"http://localhost:9998/tika/text").accept(new String[]{"application/json"}).put((Object)Files.newInputStream(tmp, new OpenOption[0]));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        String t = metadata.get(TikaCoreProperties.TIKA_CONTENT);
        Assertions.assertEquals((int)30000000, (int)t.trim().length());
    }
}

