/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.FetcherStreamFactory;
import org.apache.tika.server.core.InputStreamFactory;
import org.apache.tika.server.core.resource.RecursiveMetadataResource;
import org.apache.tika.server.core.writer.MetadataListMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="turn into actual unit tests -- this relies on network connectivity...bad")
public class FetcherTest
extends CXFTestBase {
    private static final String META_PATH = "/rmeta";
    private static final String TEXT_PATH = "/text";
    private static final String TEST_RECURSIVE_DOC = "test-documents/test_recursive_embedded.docx";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{RecursiveMetadataResource.class});
        sf.setResourceProvider(RecursiveMetadataResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new RecursiveMetadataResource()));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<MetadataListMessageBodyWriter> providers = new ArrayList<MetadataListMessageBodyWriter>();
        providers.add(new MetadataListMessageBodyWriter());
        sf.setProviders(providers);
    }

    protected InputStream getTikaConfigInputStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/config/tika-config-url-fetcher.xml");
    }

    protected InputStreamFactory getInputStreamFactory(InputStream tikaConfigInputStream) {
        FetcherStreamFactory fetcherStreamFactory;
        block8: {
            TikaInputStream tis = TikaInputStream.get((InputStream)tikaConfigInputStream);
            try {
                FetcherManager fetcherManager = FetcherManager.load((Path)tis.getPath());
                fetcherStreamFactory = new FetcherStreamFactory(fetcherManager);
                if (tis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tis != null) {
                        try {
                            tis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            tis.close();
        }
        return fetcherStreamFactory;
    }

    @Test
    public void testBasic() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).acceptEncoding(new String[]{"gzip"}).header("fetcherName", new Object[]{"url"}).header("fetchKey", new Object[]{"https://tika.apache.org"}).put((Object)"");
        InputStreamReader reader = new InputStreamReader((InputStream)new GzipCompressorInputStream((InputStream)response.getEntity()), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Metadata parent = (Metadata)metadataList.get(0);
        String txt = parent.get(TikaCoreProperties.TIKA_CONTENT);
        FetcherTest.assertContains((String)"toolkit detects and extracts metadata", (String)txt);
        Assertions.assertEquals((Object)"Apache Tika \u2013 Apache Tika", (Object)parent.get(TikaCoreProperties.TITLE));
    }
}

