/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.standard;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.DetectorResource;
import org.apache.tika.server.core.writer.TarWriter;
import org.apache.tika.server.core.writer.ZipWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DetectorResourceTest
extends CXFTestBase {
    private static final String DETECT_PATH = "/detect";
    private static final String DETECT_STREAM_PATH = "/detect/stream";
    private static final String FOO_CSV = "test-documents/foo.csv";
    private static final String CDEC_CSV_NO_EXT = "test-documents/CDEC_WEATHER_2010_03_02";

    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{DetectorResource.class});
        sf.setResourceProvider(DetectorResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new DetectorResource(new ServerStatus("", 0))));
    }

    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TarWriter());
        providers.add(new ZipWriter());
        providers.add(new TikaServerParseExceptionMapper(false));
        sf.setProviders(providers);
    }

    @Test
    public void testDetectCsvWithExt() throws Exception {
        String url = "http://localhost:9998/detect/stream";
        Response response = WebClient.create((String)"http://localhost:9998/detect/stream").type("text/csv").accept(new String[]{"*/*"}).header("Content-Disposition", new Object[]{"attachment; filename=test-documents/foo.csv"}).put((Object)ClassLoader.getSystemResourceAsStream(FOO_CSV));
        Assertions.assertNotNull((Object)response);
        String readMime = DetectorResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"text/csv", (Object)readMime);
    }

    @Test
    public void testDetectCsvNoExt() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/detect/stream").type("text/csv").accept(new String[]{"*/*"}).header("Content-Disposition", new Object[]{"attachment; filename=test-documents/CDEC_WEATHER_2010_03_02"}).put((Object)ClassLoader.getSystemResourceAsStream(CDEC_CSV_NO_EXT));
        Assertions.assertNotNull((Object)response);
        String readMime = DetectorResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"text/plain", (Object)readMime);
        response = WebClient.create((String)"http://localhost:9998/detect/stream").type("text/csv").accept(new String[]{"*/*"}).header("Content-Disposition", new Object[]{"attachment; filename=test-documents/CDEC_WEATHER_2010_03_02.csv"}).put((Object)ClassLoader.getSystemResourceAsStream(CDEC_CSV_NO_EXT));
        Assertions.assertNotNull((Object)response);
        readMime = DetectorResourceTest.getStringFromInputStream((InputStream)((InputStream)response.getEntity()));
        Assertions.assertEquals((Object)"text/csv", (Object)readMime);
    }
}

