/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.eval;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.tika.eval.core.metadata.TikaEvalMetadataFilter;
import org.apache.tika.server.core.ProduceTypeResourceComparator;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.writer.JSONObjWriter;
import org.apache.tika.server.eval.TikaEvalResource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TikaEvalResourceTest {
    protected static final String END_POINT = "http://localhost:9998";
    protected static final String COMPARE_END_POINT = "http://localhost:9998/eval/compare";
    protected static final String PROFILE_END_POINT = "http://localhost:9998/eval/profile";
    protected static Server SERVER;
    ObjectMapper objectMapper = new ObjectMapper();

    @BeforeAll
    public static void setUp() throws Exception {
        ServerStatus serverStatus = new ServerStatus("", 0, true);
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setOutInterceptors(Collections.singletonList(new GZIPOutInterceptor()));
        sf.setInInterceptors(Collections.singletonList(new GZIPInInterceptor()));
        TikaEvalResourceTest.setUpResources(sf, serverStatus);
        TikaEvalResourceTest.setUpProviders(sf);
        sf.setAddress("http://localhost:9998/");
        sf.setResourceComparator((ResourceComparator)new ProduceTypeResourceComparator());
        BindingFactoryManager manager = (BindingFactoryManager)sf.getBus().getExtension(BindingFactoryManager.class);
        JAXRSBindingFactory factory = new JAXRSBindingFactory();
        factory.setBus(sf.getBus());
        manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)factory);
        SERVER = sf.create();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        SERVER.stop();
        SERVER.destroy();
    }

    protected static void setUpResources(JAXRSServerFactoryBean sf, ServerStatus serverStatus) {
        sf.setResourceClasses(new Class[]{TikaEvalResource.class});
        TikaEvalResource tikaEvalResource = new TikaEvalResource();
        tikaEvalResource.setServerStatus(serverStatus);
        sf.setResourceProvider(TikaEvalResource.class, (ResourceProvider)new SingletonResourceProvider((Object)tikaEvalResource));
    }

    protected static void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<JSONObjWriter> providers = new ArrayList<JSONObjWriter>();
        providers.add(new JSONObjWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testBasicProfile() throws Exception {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("id", "1");
        request.put("text", "the quick brown fox jumped qwertyuiop");
        Response response = this.profile(request);
        Map<String, Object> results = this.deserialize(response);
        Assertions.assertEquals((int)6, (int)((Integer)results.get(TikaEvalMetadataFilter.NUM_TOKENS.getName())));
        Assertions.assertEquals((double)0.166, (double)((Double)results.get(TikaEvalMetadataFilter.OUT_OF_VOCABULARY.getName())), (double)0.01);
        Assertions.assertEquals((Object)"eng", (Object)((String)results.get(TikaEvalMetadataFilter.LANGUAGE.getName())));
    }

    @Test
    public void testBasicCompare() throws Exception {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("id", "1");
        request.put("textA", "the quick brown fox jumped qwertyuiop");
        request.put("textB", "the the the fast brown dog jumped qwertyuiop");
        Response response = this.compare(request);
        Map<String, Object> results = this.deserialize(response);
        Assertions.assertEquals((int)6, (int)((Integer)results.get(TikaEvalMetadataFilter.NUM_TOKENS.getName() + "A")));
        Assertions.assertEquals((double)0.166, (double)((Double)results.get(TikaEvalMetadataFilter.OUT_OF_VOCABULARY.getName() + "A")), (double)0.01);
        Assertions.assertEquals((Object)"eng", (Object)results.get(TikaEvalMetadataFilter.LANGUAGE.getName() + "A"));
        Assertions.assertEquals((double)0.666, (double)((Double)results.get(TikaEvalResource.DICE.getName())), (double)0.01);
        Assertions.assertEquals((double)0.571, (double)((Double)results.get(TikaEvalResource.OVERLAP.getName())), (double)0.01);
    }

    private Map<String, Object> deserialize(Response response) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));){
            Map map = (Map)this.objectMapper.readValue((Reader)reader, (TypeReference)typeRef);
            return map;
        }
    }

    private Response profile(Map<String, String> request) throws JsonProcessingException {
        String jsonRequest = this.objectMapper.writeValueAsString(request);
        return WebClient.create((String)PROFILE_END_POINT).type("application/json").accept(new String[]{"application/json"}).put((Object)jsonRequest.getBytes(StandardCharsets.UTF_8));
    }

    private Response compare(Map<String, String> request) throws JsonProcessingException {
        String jsonRequest = this.objectMapper.writeValueAsString(request);
        return WebClient.create((String)COMPARE_END_POINT).type("application/json").accept(new String[]{"application/json"}).put((Object)jsonRequest.getBytes(StandardCharsets.UTF_8));
    }
}

