/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.writer;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.server.core.MetadataList;

@Provider
@Produces(value={"application/json"})
public class MetadataListMessageBodyWriter
implements MessageBodyWriter<MetadataList> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!MediaType.APPLICATION_JSON_TYPE.equals(mediaType)) {
            return false;
        }
        return type.isAssignableFrom(MetadataList.class);
    }

    @Override
    public long getSize(MetadataList data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(MetadataList list, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try (OutputStreamWriter writer = new OutputStreamWriter(entityStream, StandardCharsets.UTF_8);){
            JsonMetadataList.toJson(list.getMetadata(), writer);
        }
    }
}

