/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.writer;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.tika.metadata.Metadata;

@Provider
@Produces(value={"text/csv"})
public class CSVMessageBodyWriter
implements MessageBodyWriter<Metadata> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Metadata.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Metadata data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Metadata metadata, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        CSVPrinter writer = new CSVPrinter(new OutputStreamWriter(entityStream, StandardCharsets.UTF_8), CSVFormat.EXCEL);
        for (String name : metadata.names()) {
            String[] values = metadata.getValues(name);
            ArrayList<String> list = new ArrayList<String>(values.length + 1);
            list.add(name);
            list.addAll(Arrays.asList(values));
            writer.printRecord(list);
        }
        writer.flush();
    }
}

